/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core.trace;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.trace.ArtifactDefinitions;
import software.amazon.smithy.codegen.core.trace.ShapeLink;
import software.amazon.smithy.codegen.core.trace.TraceMetadata;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class TraceFile
implements ToNode,
ToSmithyBuilder<TraceFile> {
    public static final String SMITHY_TRACE_TEXT = "smithyTrace";
    public static final String METADATA_TEXT = "metadata";
    public static final String DEFINITIONS_TEXT = "definitions";
    public static final String SHAPES_TEXT = "shapes";
    public static final String SMITHY_TRACE_VERSION = "1.0";
    private String smithyTrace;
    private TraceMetadata metadata;
    private ArtifactDefinitions artifactDefinitions;
    private Map<ShapeId, List<ShapeLink>> shapes;

    private TraceFile(Builder builder) {
        this.smithyTrace = (String)SmithyBuilder.requiredState((String)SMITHY_TRACE_TEXT, (Object)builder.smithyTrace);
        this.metadata = (TraceMetadata)SmithyBuilder.requiredState((String)METADATA_TEXT, (Object)builder.metadata);
        if (((Map)builder.shapes.peek()).isEmpty()) {
            throw new IllegalStateException("TraceFile's shapes field must not be empty to build it.");
        }
        this.shapes = (Map)builder.shapes.copy();
        this.artifactDefinitions = builder.artifactDefinitions;
        this.validateTypesAndTags();
    }

    public static TraceFile fromNode(Node value) {
        ObjectNode node = value.expectObjectNode();
        Builder builder = TraceFile.builder().smithyTrace(node.expectStringMember(SMITHY_TRACE_TEXT).getValue()).metadata(TraceMetadata.fromNode((Node)node.expectObjectMember(METADATA_TEXT)));
        Map shapeMap = node.expectObjectMember(SHAPES_TEXT).getMembers();
        for (Map.Entry entry : shapeMap.entrySet()) {
            for (Node linkNode : ((Node)entry.getValue()).expectArrayNode().getElements()) {
                builder.addShapeLink(((StringNode)entry.getKey()).getValue(), ShapeLink.fromNode(linkNode));
            }
        }
        if (node.containsMember(DEFINITIONS_TEXT)) {
            builder.definitions(ArtifactDefinitions.fromNode((Node)node.expectObjectMember(DEFINITIONS_TEXT)));
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public ObjectNode toNode() {
        ObjectNode.Builder shapesBuilder = ObjectNode.objectNodeBuilder();
        for (Map.Entry<ShapeId, List<ShapeLink>> entry : this.shapes.entrySet()) {
            String shapeId = entry.getKey().toString();
            ArrayNode shapeListNode = (ArrayNode)entry.getValue().stream().map(ShapeLink::toNode).collect(ArrayNode.collect());
            shapesBuilder.withMember(shapeId, (ToNode)shapeListNode);
        }
        return ObjectNode.objectNodeBuilder().withMember(SMITHY_TRACE_TEXT, this.smithyTrace).withMember(METADATA_TEXT, (ToNode)this.metadata).withOptionalMember(DEFINITIONS_TEXT, this.getArtifactDefinitions()).withMember(SHAPES_TEXT, (ToNode)shapesBuilder.build()).build();
    }

    private void validateTypesAndTags() {
        if (this.artifactDefinitions != null) {
            for (Map.Entry<ShapeId, List<ShapeLink>> entry : this.shapes.entrySet()) {
                for (ShapeLink link : entry.getValue()) {
                    if (!this.artifactDefinitions.getTypes().containsKey(link.getType())) {
                        throw new ExpectationNotMetException(entry.getKey().toString() + " contains types that aren't in definitions.", (FromSourceLocation)SourceLocation.none());
                    }
                    List<String> tags = link.getTags();
                    for (String tag : tags) {
                        if (this.artifactDefinitions.getTags().containsKey(tag)) continue;
                        throw new ExpectationNotMetException(entry.getKey().toString() + " " + tag + " is a tag that isn't in definitions.", (FromSourceLocation)SourceLocation.none());
                    }
                }
            }
        }
    }

    public void validateModel(Model model) {
        HashSet<ShapeId> fileShapes = new HashSet<ShapeId>(this.shapes.keySet());
        HashSet<ShapeId> fileShapesCopy = new HashSet<ShapeId>(fileShapes);
        Set modelShapes = model.toSet().stream().filter(shape -> !Prelude.isPreludeShape((ToShapeId)shape)).map(Shape::getId).collect(Collectors.toSet());
        fileShapes.removeAll(modelShapes);
        modelShapes.removeAll(fileShapesCopy);
        if (fileShapes.size() > 0 || modelShapes.size() > 0) {
            StringBuilder errorMessageBuilder = new StringBuilder().append("Model validation failed.");
            if (fileShapes.size() > 0) {
                errorMessageBuilder.append(" The following shapes are in the TraceFile, but missing from the model: ");
                fileShapes.stream().forEach(id -> errorMessageBuilder.append(id.toString()).append(", "));
                errorMessageBuilder.append(". ");
            }
            if (modelShapes.size() > 0) {
                errorMessageBuilder.append("The following shapes are in the model, but missing from the TraceFile: ");
                modelShapes.stream().forEach(id -> errorMessageBuilder.append(id.toString()).append(", "));
                errorMessageBuilder.append(". ");
            }
            throw new ExpectationNotMetException(errorMessageBuilder.toString(), (FromSourceLocation)SourceLocation.none());
        }
    }

    public String getSmithyTrace() {
        return this.smithyTrace;
    }

    public TraceMetadata getMetadata() {
        return this.metadata;
    }

    public Optional<ArtifactDefinitions> getArtifactDefinitions() {
        return Optional.ofNullable(this.artifactDefinitions);
    }

    public Map<ShapeId, List<ShapeLink>> getShapes() {
        return this.shapes;
    }

    public Builder toBuilder() {
        return TraceFile.builder().metadata(this.metadata).smithyTrace(this.smithyTrace).definitions(this.artifactDefinitions).shapes(this.shapes);
    }

    public static final class Builder
    implements SmithyBuilder<TraceFile> {
        private final BuilderRef<Map<ShapeId, List<ShapeLink>>> shapes = BuilderRef.forUnorderedMap();
        private String smithyTrace = "1.0";
        private ArtifactDefinitions artifactDefinitions;
        private TraceMetadata metadata;

        public TraceFile build() {
            return new TraceFile(this);
        }

        public Builder smithyTrace(String smithyTrace) {
            this.smithyTrace = smithyTrace;
            return this;
        }

        public Builder definitions(ArtifactDefinitions artifactDefinitions) {
            this.artifactDefinitions = artifactDefinitions;
            return this;
        }

        public Builder metadata(TraceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder addShapeLink(ShapeId id, ShapeLink link) {
            List list = ((Map)this.shapes.get()).getOrDefault(id, new ArrayList());
            list.add(link);
            ((Map)this.shapes.get()).put(id, list);
            return this;
        }

        public Builder addShapeLink(String idString, ShapeLink link) {
            return this.addShapeLink(ShapeId.from((String)idString), link);
        }

        public Builder addShapeLinks(ShapeId id, List<ShapeLink> linkList) {
            ((Map)this.shapes.get()).put(id, linkList);
            return this;
        }

        public Builder addShapeLinks(String idString, List<ShapeLink> linkList) {
            return this.addShapeLinks(ShapeId.from((String)idString), linkList);
        }

        public Builder shapes(Map<ShapeId, List<ShapeLink>> shapes) {
            this.shapes.clear();
            shapes.forEach(this::addShapeLinks);
            return this;
        }
    }
}

