/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core.trace;

import java.util.Map;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ArtifactDefinitions
implements ToNode,
ToSmithyBuilder<ArtifactDefinitions> {
    public static final String TYPE_TEXT = "types";
    public static final String TAGS_TEXT = "tags";
    private Map<String, String> tags;
    private Map<String, String> types;

    private ArtifactDefinitions(Builder builder) {
        if (((Map)builder.tags.peek()).isEmpty()) {
            throw new IllegalStateException("ArtifactDefinition's Tags field must not be empty.");
        }
        if (((Map)builder.types.peek()).isEmpty()) {
            throw new IllegalStateException("ArtifactDefinition's Types field must not be empty.");
        }
        this.tags = (Map)builder.tags.copy();
        this.types = (Map)builder.types.copy();
    }

    public static ArtifactDefinitions fromNode(Node value) {
        NodeMapper mapper = new NodeMapper();
        mapper.disableFromNodeForClass(ArtifactDefinitions.class);
        return (ArtifactDefinitions)mapper.deserialize(value, ArtifactDefinitions.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ObjectNode toNode() {
        return ObjectNode.objectNodeBuilder().withMember(TAGS_TEXT, (ToNode)ObjectNode.fromStringMap(this.tags)).withMember(TYPE_TEXT, (ToNode)ObjectNode.fromStringMap(this.types)).build();
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Map<String, String> getTypes() {
        return this.types;
    }

    public Builder toBuilder() {
        return ArtifactDefinitions.builder().tags(this.tags).types(this.types);
    }

    public static final class Builder
    implements SmithyBuilder<ArtifactDefinitions> {
        private final BuilderRef<Map<String, String>> tags = BuilderRef.forUnorderedMap();
        private final BuilderRef<Map<String, String>> types = BuilderRef.forUnorderedMap();

        public ArtifactDefinitions build() {
            return new ArtifactDefinitions(this);
        }

        public Builder tags(Map<String, String> tags) {
            this.tags.clear();
            tags.forEach(this::addTag);
            return this;
        }

        public Builder types(Map<String, String> types) {
            this.types.clear();
            types.forEach(this::addType);
            return this;
        }

        public Builder addTag(String name, String description) {
            ((Map)this.tags.get()).put(name, description);
            return this;
        }

        public Builder addType(String name, String description) {
            ((Map)this.types.get()).put(name, description);
            return this;
        }
    }
}

