/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.Locale;
import java.util.Map;
import software.amazon.smithy.codegen.core.ReservedWords;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;

public final class MappedReservedWords
implements ReservedWords {
    private final Map<String, String> mappings;
    private final Map<String, String> caseInsensitiveMappings;

    public MappedReservedWords(Map<String, String> mappings, Map<String, String> caseInsensitiveMappings) {
        this.mappings = MapUtils.copyOf(mappings);
        this.caseInsensitiveMappings = MapUtils.copyOf(caseInsensitiveMappings);
    }

    private MappedReservedWords(Builder builder) {
        this.mappings = (Map)builder.mappings.copy();
        this.caseInsensitiveMappings = (Map)builder.caseInsensitiveMappings.copy();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String escape(String word) {
        String result = this.mappings.get(word);
        if (result == null && !this.caseInsensitiveMappings.isEmpty()) {
            result = this.caseInsensitiveMappings.get(word.toLowerCase(Locale.US));
        }
        return result != null ? result : word;
    }

    @Override
    public boolean isReserved(String word) {
        if (this.mappings.containsKey(word)) {
            return true;
        }
        return !this.caseInsensitiveMappings.isEmpty() && this.caseInsensitiveMappings.containsKey(word.toLowerCase(Locale.US));
    }

    public static final class Builder
    implements SmithyBuilder<ReservedWords> {
        private final BuilderRef<Map<String, String>> mappings = BuilderRef.forUnorderedMap();
        private final BuilderRef<Map<String, String>> caseInsensitiveMappings = BuilderRef.forUnorderedMap();

        private Builder() {
        }

        public Builder put(String reservedWord, String conversion) {
            ((Map)this.mappings.get()).put(reservedWord, conversion);
            return this;
        }

        public Builder putCaseInsensitive(String reservedWord, String conversion) {
            ((Map)this.caseInsensitiveMappings.get()).put(reservedWord.toLowerCase(Locale.US), conversion);
            return this;
        }

        public ReservedWords build() {
            return new MappedReservedWords(this);
        }
    }
}

