/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipDirection;
import software.amazon.smithy.model.selector.PathFinder;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;

public final class TopologicalIndex
implements KnowledgeIndex {
    private final Set<Shape> shapes = new LinkedHashSet<Shape>();
    private final Map<Shape, Set<PathFinder.Path>> recursiveShapes = new LinkedHashMap<Shape, Set<PathFinder.Path>>();

    public TopologicalIndex(Model model) {
        TreeSet<Shape> shapes = new TreeSet<Shape>();
        for (Shape shape : model.toSet()) {
            if (Prelude.isPreludeShape((ToShapeId)shape)) continue;
            shapes.add(shape);
        }
        TreeMap<Integer, Map> frequencyMap = new TreeMap<Integer, Map>();
        NeighborProvider provider = NeighborProviderIndex.of((Model)model).getProvider();
        for (Shape shape : shapes) {
            Set<PathFinder.Path> paths = this.explore(shape, Collections.emptyList(), Collections.emptySet(), provider);
            if (paths.isEmpty()) continue;
            int edges = 0;
            for (PathFinder.Path path : paths) {
                edges += path.size();
            }
            frequencyMap.computeIfAbsent(edges, e -> new LinkedHashMap()).put(shape, paths);
        }
        for (Map.Entry entry : frequencyMap.entrySet()) {
            this.recursiveShapes.putAll((Map)entry.getValue());
        }
    }

    private Set<PathFinder.Path> explore(Shape shape, List<Relationship> path, Set<Shape> visited, NeighborProvider provider) {
        if (visited.contains(shape)) {
            return Collections.singleton(new PathFinder.Path(path));
        }
        LinkedHashSet<Shape> newVisited = new LinkedHashSet<Shape>(visited);
        newVisited.add(shape);
        TreeMap<Shape, Relationship> shapeRelationshipMap = new TreeMap<Shape, Relationship>();
        for (Relationship rel : provider.getNeighbors(shape)) {
            if (rel.getRelationshipType().getDirection() != RelationshipDirection.DIRECTED || rel.getNeighborShapeId().equals((Object)shape.getId()) || !rel.getNeighborShape().isPresent()) continue;
            shapeRelationshipMap.put((Shape)rel.getNeighborShape().get(), rel);
        }
        if (shapeRelationshipMap.isEmpty()) {
            this.shapes.add(shape);
            return Collections.emptySet();
        }
        LinkedHashSet<PathFinder.Path> recursivePaths = new LinkedHashSet<PathFinder.Path>();
        for (Map.Entry entry : shapeRelationshipMap.entrySet()) {
            ArrayList<Relationship> newPath = new ArrayList<Relationship>(path.size() + 1);
            newPath.addAll(path);
            newPath.add((Relationship)entry.getValue());
            recursivePaths.addAll(this.explore((Shape)entry.getKey(), newPath, newVisited, provider));
        }
        if (recursivePaths.isEmpty()) {
            this.shapes.add(shape);
        }
        return recursivePaths;
    }

    public static TopologicalIndex of(Model model) {
        return (TopologicalIndex)model.getKnowledge(TopologicalIndex.class, TopologicalIndex::new);
    }

    public Set<Shape> getOrderedShapes() {
        return Collections.unmodifiableSet(this.shapes);
    }

    public Set<Shape> getRecursiveShapes() {
        return Collections.unmodifiableSet(this.recursiveShapes.keySet());
    }

    public boolean isRecursive(ToShapeId shape) {
        return !this.getRecursiveClosure(shape).isEmpty();
    }

    public Set<PathFinder.Path> getRecursiveClosure(ToShapeId shape) {
        if (shape instanceof Shape) {
            return Collections.unmodifiableSet(this.recursiveShapes.getOrDefault(shape, Collections.emptySet()));
        }
        ShapeId id = shape.toShapeId();
        for (Map.Entry<Shape, Set<PathFinder.Path>> entry : this.recursiveShapes.entrySet()) {
            if (!entry.getKey().getId().equals((Object)id)) continue;
            return Collections.unmodifiableSet(entry.getValue());
        }
        return Collections.emptySet();
    }
}

