/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core.trace;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.TimeZone;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class TraceMetadata
implements ToNode,
ToSmithyBuilder<TraceMetadata> {
    public static final String ID_TEXT = "id";
    public static final String VERSION_TEXT = "version";
    public static final String TYPE_TEXT = "type";
    public static final String TYPE_VERSION_TEXT = "typeVersion";
    public static final String HOMEPAGE_TEXT = "homepage";
    public static final String TIMESTAMP_TEXT = "timestamp";
    private String id;
    private String version;
    private String timestamp;
    private String type;
    private String typeVersion;
    private String homepage;

    private TraceMetadata(Builder builder) {
        this.id = (String)SmithyBuilder.requiredState((String)ID_TEXT, (Object)builder.id);
        this.version = (String)SmithyBuilder.requiredState((String)VERSION_TEXT, (Object)builder.version);
        this.timestamp = (String)SmithyBuilder.requiredState((String)TIMESTAMP_TEXT, (Object)builder.timestamp);
        this.type = (String)SmithyBuilder.requiredState((String)TYPE_TEXT, (Object)builder.type);
        this.typeVersion = builder.typeVersion;
        this.homepage = builder.homepage;
    }

    public static TraceMetadata fromNode(Node value) {
        NodeMapper mapper = new NodeMapper();
        mapper.disableFromNodeForClass(TraceMetadata.class);
        return (TraceMetadata)mapper.deserialize(value, TraceMetadata.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ObjectNode toNode() {
        return ObjectNode.objectNodeBuilder().withMember(ID_TEXT, this.id).withMember(VERSION_TEXT, this.version).withMember(TYPE_TEXT, this.type).withMember(TIMESTAMP_TEXT, this.timestamp).withOptionalMember(TYPE_VERSION_TEXT, this.getTypeVersion().map(Node::from)).withOptionalMember(HOMEPAGE_TEXT, this.getHomepage().map(Node::from)).build();
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }

    public Optional<String> getTypeVersion() {
        return Optional.ofNullable(this.typeVersion);
    }

    public Optional<String> getHomepage() {
        return Optional.ofNullable(this.homepage);
    }

    public Builder toBuilder() {
        return TraceMetadata.builder().id(this.id).version(this.version).timestamp(this.timestamp).type(this.type).typeVersion(this.typeVersion).homepage(this.homepage);
    }

    public static final class Builder
    implements SmithyBuilder<TraceMetadata> {
        private String id;
        private String version;
        private String timestamp;
        private String type;
        private String typeVersion;
        private String homepage;

        public TraceMetadata build() {
            return new TraceMetadata(this);
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder setTimestampAsNow() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.timestamp = dateFormat.format(new Date());
            return this;
        }

        public Builder typeVersion(String typeVersion) {
            this.typeVersion = typeVersion;
            return this;
        }

        public Builder homepage(String homepage) {
            this.homepage = homepage;
            return this;
        }
    }
}

