/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core.directed;

import software.amazon.smithy.codegen.core.CodegenContext;
import software.amazon.smithy.codegen.core.directed.ShapeDirective;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.shapes.EnumShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.EnumTrait;

public final class GenerateEnumDirective<C extends CodegenContext<S, ?, ?>, S>
extends ShapeDirective<Shape, C, S> {
    GenerateEnumDirective(C context, ServiceShape service, Shape shape) {
        super(context, service, GenerateEnumDirective.validateShape(shape));
    }

    private static Shape validateShape(Shape shape) {
        if (shape.isEnumShape() || shape.isStringShape() && shape.hasTrait(EnumTrait.class)) {
            return shape;
        }
        throw new IllegalArgumentException("GenerateEnum requires an enum shape or a string shape with the enum trait");
    }

    public EnumType getEnumType() {
        return this.shape().isEnumShape() ? EnumType.ENUM : EnumType.STRING;
    }

    public EnumTrait getEnumTrait() {
        return (EnumTrait)this.shape().expectTrait(EnumTrait.class);
    }

    public EnumShape expectEnumShape() {
        return (EnumShape)this.shape().asEnumShape().orElseThrow(() -> new ExpectationNotMetException("Expected an enum shape, but found " + this.shape(), this.shape()));
    }

    public static enum EnumType {
        STRING,
        ENUM;

    }
}

