/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core.directed;

import java.util.Map;
import java.util.TreeMap;
import software.amazon.smithy.codegen.core.CodegenContext;
import software.amazon.smithy.codegen.core.directed.ShapeDirective;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.EventStreamIndex;
import software.amazon.smithy.model.knowledge.EventStreamInfo;
import software.amazon.smithy.model.knowledge.PaginatedIndex;
import software.amazon.smithy.model.knowledge.PaginationInfo;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.traits.TitleTrait;

public final class GenerateServiceDirective<C extends CodegenContext<S, ?, ?>, S>
extends ShapeDirective<ServiceShape, C, S> {
    GenerateServiceDirective(C context, ServiceShape service) {
        super(context, service, service);
    }

    public String serviceTitle() {
        return this.serviceTitle(this.symbol().getName());
    }

    public String serviceTitle(String fallback) {
        return ((ServiceShape)this.shape()).getTrait(TitleTrait.class).map(StringTrait::getValue).orElse(fallback);
    }

    Map<ShapeId, PaginationInfo> paginatedOperations() {
        TreeMap<ShapeId, PaginationInfo> result = new TreeMap<ShapeId, PaginationInfo>();
        PaginatedIndex index = PaginatedIndex.of((Model)this.model());
        for (OperationShape operation : this.operations()) {
            index.getPaginationInfo((ToShapeId)this.service(), (ToShapeId)operation).ifPresent(i -> result.put(operation.getId(), (PaginationInfo)i));
        }
        return result;
    }

    public Map<ShapeId, EventStreamInfo> inputEventStreamOperations() {
        TreeMap<ShapeId, EventStreamInfo> result = new TreeMap<ShapeId, EventStreamInfo>();
        EventStreamIndex index = EventStreamIndex.of((Model)this.model());
        for (OperationShape operation : this.operations()) {
            index.getInputInfo((ToShapeId)operation).ifPresent(i -> result.put(operation.getId(), (EventStreamInfo)i));
        }
        return result;
    }

    public Map<ShapeId, EventStreamInfo> outputEventStreamOperations() {
        TreeMap<ShapeId, EventStreamInfo> result = new TreeMap<ShapeId, EventStreamInfo>();
        EventStreamIndex index = EventStreamIndex.of((Model)this.model());
        for (OperationShape operation : this.operations()) {
            index.getOutputInfo((ToShapeId)operation).ifPresent(i -> result.put(operation.getId(), (EventStreamInfo)i));
        }
        return result;
    }
}

