/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

public interface ReservedWords {
    public String escape(String var1);

    public boolean isReserved(String var1);

    public static ReservedWords identity() {
        return new ReservedWords(){

            @Override
            public String escape(String word) {
                return word;
            }

            @Override
            public boolean isReserved(String word) {
                return false;
            }
        };
    }

    public static ReservedWords compose(final ReservedWords ... delegates) {
        return new ReservedWords(){

            @Override
            public String escape(String word) {
                for (ReservedWords reservedWords : delegates) {
                    if (!reservedWords.isReserved(word)) continue;
                    return reservedWords.escape(word);
                }
                return word;
            }

            @Override
            public boolean isReserved(String word) {
                for (ReservedWords reservedWords : delegates) {
                    if (!reservedWords.isReserved(word)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

