/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core.directed;

import software.amazon.smithy.codegen.core.CodegenContext;
import software.amazon.smithy.codegen.core.directed.ShapeDirective;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.EnumTrait;

public final class GenerateEnumDirective<C extends CodegenContext<S, ?, ?>, S>
extends ShapeDirective<Shape, C, S> {
    GenerateEnumDirective(C context, ServiceShape service, Shape shape) {
        super(context, service, GenerateEnumDirective.validateShape(shape));
    }

    private static Shape validateShape(Shape shape) {
        if (!shape.isStringShape() || !shape.hasTrait(EnumTrait.class)) {
            throw new IllegalArgumentException("GenerateEnum requires a string shape with the enum trait");
        }
        return shape;
    }

    public EnumType getEnumType() {
        return EnumType.STRING;
    }

    public EnumTrait getEnumTrait() {
        return (EnumTrait)this.shape().expectTrait(EnumTrait.class);
    }

    public static enum EnumType {
        STRING;

    }
}

