/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core.directed;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Logger;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.CodegenContext;
import software.amazon.smithy.codegen.core.ImportContainer;
import software.amazon.smithy.codegen.core.SmithyIntegration;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.SymbolWriter;
import software.amazon.smithy.codegen.core.directed.CreateContextDirective;
import software.amazon.smithy.codegen.core.directed.CreateSymbolProviderDirective;
import software.amazon.smithy.codegen.core.directed.CustomizeDirective;
import software.amazon.smithy.codegen.core.directed.DirectedCodegen;
import software.amazon.smithy.codegen.core.directed.GenerateEnumDirective;
import software.amazon.smithy.codegen.core.directed.GenerateErrorDirective;
import software.amazon.smithy.codegen.core.directed.GenerateResourceDirective;
import software.amazon.smithy.codegen.core.directed.GenerateServiceDirective;
import software.amazon.smithy.codegen.core.directed.GenerateStructureDirective;
import software.amazon.smithy.codegen.core.directed.GenerateUnionDirective;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.SmithyBuilder;

public final class CodegenDirector<W extends SymbolWriter<W, ? extends ImportContainer>, I extends SmithyIntegration<S, W, C>, C extends CodegenContext<S, W>, S> {
    private static final Logger LOGGER = Logger.getLogger(DirectedCodegen.class.getName());
    private Class<I> integrationClass;
    private ShapeId service;
    private Model model;
    private S settings;
    private FileManifest fileManifest;
    private Supplier<Iterable<I>> integrationFinder;
    private DirectedCodegen<C, S> directedCodegen;
    private final List<BiFunction<Model, ModelTransformer, Model>> transforms = new ArrayList<BiFunction<Model, ModelTransformer, Model>>();

    public static Model simplifyModelForServiceCodegen(Model model, ShapeId service, ModelTransformer transformer) {
        ServiceShape serviceShape = (ServiceShape)model.expectShape(service, ServiceShape.class);
        model = transformer.copyServiceErrorsToOperations(model, serviceShape);
        model = transformer.copyServiceErrorsToOperations(model, serviceShape);
        return model;
    }

    public void integrationClass(Class<I> integrationClass) {
        this.integrationClass = integrationClass;
    }

    public void service(ShapeId service) {
        this.service = service;
    }

    public void directedCodegen(DirectedCodegen<C, S> directedCodegen) {
        this.directedCodegen = directedCodegen;
    }

    public void model(Model model) {
        this.model = model;
    }

    public void settings(S settings) {
        this.settings = settings;
    }

    public S settings(Class<S> settingsType, Node settingsNode) {
        LOGGER.fine(() -> "Loading codegen settings from node value: " + settingsNode.getSourceLocation());
        Object deserialized = new NodeMapper().deserialize(settingsNode, settingsType);
        this.settings(deserialized);
        return (S)deserialized;
    }

    public void fileManifest(FileManifest fileManifest) {
        this.fileManifest = fileManifest;
    }

    public void integrationFinder(Supplier<Iterable<I>> integrationFinder) {
        this.integrationFinder = integrationFinder;
    }

    public void integrationClassLoader(ClassLoader classLoader) {
        Objects.requireNonNull(this.integrationClass, "integrationClass() must be called before calling integrationClassLoader");
        this.integrationFinder(() -> ServiceLoader.load(this.integrationClass, classLoader));
    }

    public void performDefaultCodegenTransforms() {
        this.transforms.add((model, transformer) -> {
            LOGGER.finest("Performing default codegen model transforms for directed codegen");
            return CodegenDirector.simplifyModelForServiceCodegen(model, Objects.requireNonNull(this.service), transformer);
        });
    }

    public void createDedicatedInputsAndOutputs() {
        this.createDedicatedInputsAndOutputs("Input", "Output");
    }

    public void createDedicatedInputsAndOutputs(String inputSuffix, String outputSuffix) {
        this.transforms.add((model, transformer) -> {
            LOGGER.finest("Creating dedicated input and output shapes for directed codegen");
            return transformer.createDedicatedInputAndOutput(model, inputSuffix, outputSuffix);
        });
    }

    public void sortMembers() {
        this.transforms.add((model, transformer) -> {
            LOGGER.finest("Sorting model members for directed codegen");
            return transformer.sortMembers(model, Shape::compareTo);
        });
    }

    public void run() {
        this.validateState();
        this.performModelTransforms();
        List<I> integrations = this.findIntegrations();
        this.preprocessModelWithIntegrations(integrations);
        ServiceShape serviceShape = (ServiceShape)this.model.expectShape(this.service, ServiceShape.class);
        Set shapes = new Walker(this.model).walkShapes((Shape)serviceShape);
        SymbolProvider provider = this.createSymbolProvider(integrations, serviceShape);
        C context = this.createContext(serviceShape, provider);
        this.registerInterceptors(context, integrations);
        LOGGER.finest(() -> "Generating service " + serviceShape.getId());
        this.directedCodegen.generateService(new GenerateServiceDirective(context, serviceShape));
        this.generateShapesInService(context, serviceShape, shapes);
        CustomizeDirective postProcess = new CustomizeDirective(context, serviceShape);
        LOGGER.finest(() -> "Performing custom codegen for " + this.directedCodegen.getClass().getName() + " before integrations");
        this.directedCodegen.customizeBeforeIntegrations(postProcess);
        this.applyIntegrationCustomizations(context, integrations);
        LOGGER.finest(() -> "Performing custom codegen for " + this.directedCodegen.getClass().getName() + " after integrations");
        this.directedCodegen.customizeAfterIntegrations(postProcess);
        LOGGER.finest(() -> "Directed codegen finished for " + this.directedCodegen.getClass().getName());
        if (!context.writerDelegator().getWriters().isEmpty()) {
            LOGGER.info(() -> "Flushing remaining writers of " + this.directedCodegen.getClass().getName());
            context.writerDelegator().flushWriters();
        }
    }

    private void validateState() {
        SmithyBuilder.requiredState((String)"integrationClass", this.integrationClass);
        SmithyBuilder.requiredState((String)"service", (Object)this.service);
        SmithyBuilder.requiredState((String)"model", (Object)this.model);
        SmithyBuilder.requiredState((String)"settings", this.settings);
        SmithyBuilder.requiredState((String)"fileManifest", (Object)this.fileManifest);
        SmithyBuilder.requiredState((String)"directedCodegen", this.directedCodegen);
        if (this.integrationFinder == null) {
            LOGGER.fine(() -> String.format("Finding %s integrations using the %s class loader", this.integrationClass.getName(), CodegenDirector.class.getCanonicalName()));
            this.integrationClassLoader(this.getClass().getClassLoader());
        }
    }

    private void performModelTransforms() {
        LOGGER.fine(() -> "Performing model transformations for " + this.directedCodegen.getClass().getName());
        ModelTransformer transformer = ModelTransformer.create();
        for (BiFunction<Model, ModelTransformer, Model> transform : this.transforms) {
            this.model = transform.apply(this.model, transformer);
        }
    }

    private List<I> findIntegrations() {
        LOGGER.fine(() -> "Finding integration implementations of " + this.integrationClass.getName());
        List<I> integrations = SmithyIntegration.sort(this.integrationFinder.get());
        integrations.forEach(i -> LOGGER.finest(() -> "Found integration " + i.getClass().getCanonicalName()));
        return integrations;
    }

    private void preprocessModelWithIntegrations(List<I> integrations) {
        LOGGER.fine(() -> "Preprocessing codegen model using " + this.integrationClass.getName());
        for (SmithyIntegration integration : integrations) {
            this.model = integration.preprocessModel(this.model, this.settings);
        }
        LOGGER.finer(() -> "Preprocessing codegen model using " + this.integrationClass.getName() + " complete");
    }

    private SymbolProvider createSymbolProvider(List<I> integrations, ServiceShape serviceShape) {
        LOGGER.fine(() -> "Creating a symbol provider from " + this.settings.getClass().getName());
        SymbolProvider provider = this.directedCodegen.createSymbolProvider(new CreateSymbolProviderDirective<S>(this.model, this.settings, serviceShape));
        LOGGER.finer(() -> "Decorating symbol provider using " + this.integrationClass.getName());
        for (SmithyIntegration integration : integrations) {
            provider = integration.decorateSymbolProvider(this.model, this.settings, provider);
        }
        return provider;
    }

    private C createContext(ServiceShape serviceShape, SymbolProvider provider) {
        LOGGER.fine(() -> "Creating a codegen context for " + this.directedCodegen.getClass().getName());
        return this.directedCodegen.createContext(new CreateContextDirective<S>(this.model, this.settings, serviceShape, provider, this.fileManifest));
    }

    private void registerInterceptors(C context, List<I> integrations) {
        LOGGER.fine(() -> "Registering CodeInterceptors from integrations of " + this.integrationClass.getName());
        ArrayList interceptors = new ArrayList();
        for (SmithyIntegration integration : integrations) {
            interceptors.addAll(integration.interceptors(context));
        }
        context.writerDelegator().setInterceptors(interceptors);
    }

    private void generateShapesInService(C context, ServiceShape serviceShape, Set<Shape> shapes) {
        LOGGER.fine(() -> "Generating shapes for " + this.directedCodegen.getClass().getName());
        this.generateResourceShapes(context, serviceShape, shapes);
        this.generateStructures(context, serviceShape, shapes);
        this.generateUnionShapes(context, serviceShape, shapes);
        this.generateEnumShapes(context, serviceShape, shapes);
        LOGGER.finest(() -> "Finished generating shapes for " + this.directedCodegen.getClass().getName());
    }

    private void generateResourceShapes(C context, ServiceShape serviceShape, Set<Shape> shapes) {
        for (ResourceShape shape : this.model.getResourceShapes()) {
            if (!shapes.contains(shape)) continue;
            LOGGER.finest(() -> "Generating resource " + shape.getId());
            this.directedCodegen.generateResource(new GenerateResourceDirective(context, serviceShape, shape));
        }
    }

    private void generateStructures(C context, ServiceShape serviceShape, Set<Shape> shapes) {
        for (StructureShape shape : this.model.getStructureShapes()) {
            if (!shapes.contains(shape)) continue;
            if (shape.hasTrait(ErrorTrait.class)) {
                LOGGER.finest(() -> "Generating error " + shape.getId());
                this.directedCodegen.generateError(new GenerateErrorDirective(context, serviceShape, shape));
                continue;
            }
            LOGGER.finest(() -> "Generating structure " + shape.getId());
            this.directedCodegen.generateStructure(new GenerateStructureDirective(context, serviceShape, shape));
        }
    }

    private void generateUnionShapes(C context, ServiceShape serviceShape, Set<Shape> shapes) {
        for (UnionShape shape : this.model.getUnionShapes()) {
            if (!shapes.contains(shape)) continue;
            LOGGER.finest(() -> "Generating union " + shape.getId());
            this.directedCodegen.generateUnion(new GenerateUnionDirective(context, serviceShape, shape));
        }
    }

    private void generateEnumShapes(C context, ServiceShape serviceShape, Set<Shape> shapes) {
        for (StringShape shape : this.model.getStringShapesWithTrait(EnumTrait.class)) {
            if (!shapes.contains(shape)) continue;
            LOGGER.finest(() -> "Generating string enum " + shape.getId());
            this.directedCodegen.generateEnumShape(new GenerateEnumDirective(context, serviceShape, (Shape)shape));
        }
    }

    private void applyIntegrationCustomizations(C context, List<I> integrations) {
        for (SmithyIntegration integration : integrations) {
            LOGGER.finest(() -> "Customizing codegen for " + this.directedCodegen.getClass().getName() + " using integration " + integration.getClass().getName());
            integration.customize(context);
        }
    }
}

