/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.ImportContainer;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolDependency;
import software.amazon.smithy.codegen.core.SymbolDependencyContainer;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.SymbolReference;
import software.amazon.smithy.codegen.core.SymbolWriter;
import software.amazon.smithy.model.shapes.Shape;

public class WriterDelegator<W extends SymbolWriter<W, ? extends ImportContainer>>
implements SymbolDependencyContainer {
    private final FileManifest fileManifest;
    private final SymbolProvider symbolProvider;
    private final Map<String, W> writers = new TreeMap<String, W>();
    private final SymbolWriter.Factory<W> factory;
    private String automaticSeparator = "\n";

    public WriterDelegator(FileManifest fileManifest, SymbolProvider symbolProvider, SymbolWriter.Factory<W> factory) {
        this.fileManifest = fileManifest;
        this.symbolProvider = symbolProvider;
        this.factory = factory;
    }

    @Override
    public List<SymbolDependency> getDependencies() {
        ArrayList<SymbolDependency> resolved = new ArrayList<SymbolDependency>();
        this.writers.values().forEach(s -> resolved.addAll(s.getDependencies()));
        return resolved;
    }

    public void flushWriters() {
        for (Map.Entry<String, W> entry : this.getWriters().entrySet()) {
            this.fileManifest.writeFile(entry.getKey(), ((SymbolWriter)entry.getValue()).toString());
        }
        this.writers.clear();
    }

    public final Map<String, W> getWriters() {
        return Collections.unmodifiableMap(this.writers);
    }

    public final void useFileWriter(String filename, Consumer<W> writerConsumer) {
        this.useFileWriter(filename, "", writerConsumer);
    }

    public final void useFileWriter(String filename, String namespace, Consumer<W> writerConsumer) {
        writerConsumer.accept(this.checkoutWriter(filename, namespace));
    }

    public void useShapeWriter(Shape shape, Consumer<W> writerConsumer) {
        Symbol symbol = this.symbolProvider.toSymbol(shape);
        W writer = this.checkoutWriter(symbol.getDefinitionFile(), symbol.getNamespace());
        ((SymbolWriter)writer).addImportReferences(symbol, SymbolReference.ContextOption.DECLARE);
        symbol.getDependencies().forEach(arg_0 -> writer.addDependency(arg_0));
        writer.pushState();
        writerConsumer.accept(writer);
        writer.popState();
    }

    public final void setAutomaticSeparator(String automaticSeparator) {
        this.automaticSeparator = Objects.requireNonNull(automaticSeparator);
    }

    private W checkoutWriter(String filename, String namespace) {
        String formattedFilename = Paths.get(filename, new String[0]).normalize().toString();
        boolean needsNewline = this.writers.containsKey(formattedFilename);
        SymbolWriter writer = this.writers.computeIfAbsent(formattedFilename, file -> this.factory.apply((String)file, namespace));
        if (needsNewline) {
            writer.writeInline(this.automaticSeparator, new Object[0]);
        }
        return (W)writer;
    }
}

