/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core.writer;

import java.util.function.Function;
import software.amazon.smithy.codegen.core.writer.DocumentationWriter;
import software.amazon.smithy.utils.AbstractCodeWriter;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class JavaStyleDocumentationWriterBuilder {
    private String namedDocumentationSection;
    private Function<String, String> mappingFunction;
    private boolean escapeAtSignWithEntity;

    public static String escapeClosingChars(String contents) {
        return contents.replace("*/", "*\\/");
    }

    public static String escapeAtSignWithEntity(String contents) {
        return contents.replace("@", "&#064;");
    }

    public <T extends AbstractCodeWriter<T>> DocumentationWriter<T> build() {
        Function<String, String> function = this.resolveMappingFunction();
        String sectionName = this.namedDocumentationSection;
        return (writer, runnable) -> {
            if (sectionName != null) {
                writer.pushState(sectionName);
            }
            writer.pushFilteredState(function);
            writer.writeWithNoFormatting((Object)"/**");
            writer.setNewlinePrefix(" * ");
            runnable.run();
            writer.ensureNewline();
            writer.popState();
            writer.writeWithNoFormatting((Object)" */");
            if (sectionName != null) {
                writer.popState();
            }
        };
    }

    private Function<String, String> resolveMappingFunction() {
        Function<String, String> function = this.mappingFunction;
        if (this.mappingFunction == null) {
            function = JavaStyleDocumentationWriterBuilder::escapeClosingChars;
        }
        if (this.escapeAtSignWithEntity) {
            function = function.andThen(JavaStyleDocumentationWriterBuilder::escapeAtSignWithEntity);
        }
        return function;
    }

    public JavaStyleDocumentationWriterBuilder namedDocumentationSection(String namedDocumentationSection) {
        this.namedDocumentationSection = namedDocumentationSection;
        return this;
    }

    public JavaStyleDocumentationWriterBuilder mappingFunction(Function<String, String> mappingFunction) {
        this.mappingFunction = mappingFunction;
        return this;
    }

    public JavaStyleDocumentationWriterBuilder escapeAtSignWithEntity(boolean escapeAtSignWithEntity) {
        this.escapeAtSignWithEntity = escapeAtSignWithEntity;
        return this;
    }
}

