/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core.trace;

import java.util.HashMap;
import java.util.Map;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ArtifactDefinitions
implements ToNode,
ToSmithyBuilder<ArtifactDefinitions> {
    public static final String TYPE_TEXT = "types";
    public static final String TAGS_TEXT = "tags";
    private Map<String, String> tags;
    private Map<String, String> types;

    private ArtifactDefinitions(Builder builder) {
        if (builder.tags.isEmpty()) {
            throw new IllegalStateException("ArtifactDefinition's Tags field must not be empty.");
        }
        if (builder.types.isEmpty()) {
            throw new IllegalStateException("ArtifactDefinition's Types field must not be empty.");
        }
        this.tags = MapUtils.copyOf((Map)builder.tags);
        this.types = MapUtils.copyOf((Map)builder.types);
    }

    public static ArtifactDefinitions fromNode(Node value) {
        NodeMapper mapper = new NodeMapper();
        mapper.disableFromNodeForClass(ArtifactDefinitions.class);
        return (ArtifactDefinitions)mapper.deserialize(value, ArtifactDefinitions.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ObjectNode toNode() {
        return ObjectNode.objectNodeBuilder().withMember(TAGS_TEXT, (ToNode)ObjectNode.fromStringMap(this.tags)).withMember(TYPE_TEXT, (ToNode)ObjectNode.fromStringMap(this.types)).build();
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Map<String, String> getTypes() {
        return this.types;
    }

    public Builder toBuilder() {
        return ArtifactDefinitions.builder().tags(this.tags).types(this.types);
    }

    public static final class Builder
    implements SmithyBuilder<ArtifactDefinitions> {
        private final Map<String, String> tags = new HashMap<String, String>();
        private final Map<String, String> types = new HashMap<String, String>();

        public ArtifactDefinitions build() {
            return new ArtifactDefinitions(this);
        }

        public Builder tags(Map<String, String> tags) {
            this.tags.clear();
            this.tags.putAll(tags);
            return this;
        }

        public Builder types(Map<String, String> types) {
            this.types.clear();
            this.types.putAll(types);
            return this;
        }

        public Builder addTag(String name, String description) {
            this.tags.put(name, description);
            return this;
        }

        public Builder addType(String name, String description) {
            this.types.put(name, description);
            return this;
        }
    }
}

