/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.CaseInsensitiveReservedWords;
import software.amazon.smithy.codegen.core.MappedReservedWords;
import software.amazon.smithy.codegen.core.ReservedWords;
import software.amazon.smithy.utils.StringUtils;

public class ReservedWordsBuilder {
    private final Map<String, String> mappings = new HashMap<String, String>();
    private final List<ReservedWords> delegates = new ArrayList<ReservedWords>();

    public ReservedWords build() {
        ReservedWords[] words = new ReservedWords[1 + this.delegates.size()];
        words[0] = new MappedReservedWords(this.mappings, Collections.emptyMap());
        for (int i = 0; i < this.delegates.size(); ++i) {
            words[i + 1] = this.delegates.get(i);
        }
        return ReservedWords.compose(words);
    }

    public ReservedWordsBuilder put(String reservedWord, String conversion) {
        this.mappings.put(reservedWord, conversion);
        return this;
    }

    public ReservedWordsBuilder loadWords(URL location) {
        return this.loadWords(location, ReservedWordsBuilder::escapeWithUnderscore);
    }

    public ReservedWordsBuilder loadWords(URL location, Function<String, String> escaper) {
        for (String word : ReservedWordsBuilder.readNonBlankNonCommentLines(location)) {
            this.put(word, escaper.apply(word));
        }
        return this;
    }

    public ReservedWordsBuilder loadCaseInsensitiveWords(URL location) {
        return this.loadCaseInsensitiveWords(location, ReservedWordsBuilder::escapeWithUnderscore);
    }

    public ReservedWordsBuilder loadCaseInsensitiveWords(URL location, Function<String, String> escaper) {
        this.delegates.add(new CaseInsensitiveReservedWords(ReservedWordsBuilder.readNonBlankNonCommentLines(location), escaper));
        return this;
    }

    private static String escapeWithUnderscore(String word) {
        return "_" + word;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Set<String> readNonBlankNonCommentLines(URL url) {
        try (InputStream is = url.openConnection().getInputStream();){
            Set<String> set;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                set = reader.lines().filter(StringUtils::isNotBlank).filter(line -> !line.startsWith("#")).map(word -> StringUtils.stripEnd((String)word, null)).collect(Collectors.toSet());
            }
            return set;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error loading reserved words from " + url + ": " + e.getMessage(), e);
        }
    }
}

