/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;

final class CachingSymbolProvider
implements SymbolProvider {
    private final SymbolProvider delegate;
    private final ConcurrentMap<ShapeId, Symbol> symbolCache = new ConcurrentHashMap<ShapeId, Symbol>();
    private final ConcurrentMap<ShapeId, String> memberCache = new ConcurrentHashMap<ShapeId, String>();

    CachingSymbolProvider(SymbolProvider delegate) {
        this.delegate = delegate;
    }

    @Override
    public Symbol toSymbol(Shape shape) {
        return this.symbolCache.computeIfAbsent(shape.toShapeId(), id -> this.delegate.toSymbol(shape));
    }

    @Override
    public String toMemberName(MemberShape shape) {
        return this.memberCache.computeIfAbsent(shape.toShapeId(), id -> this.delegate.toMemberName(shape));
    }
}

