/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import software.amazon.smithy.codegen.core.SymbolDependency;
import software.amazon.smithy.codegen.core.SymbolReference;
import software.amazon.smithy.codegen.core.TypedPropertiesBag;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Symbol
extends TypedPropertiesBag
implements ToSmithyBuilder<Symbol> {
    private final String namespace;
    private final String namespaceDelimiter;
    private final String name;
    private final String definitionFile;
    private final String declarationFile;
    private final List<SymbolReference> references;
    private final List<SymbolDependency> dependencies;

    private Symbol(Builder builder) {
        super(builder.properties);
        this.namespace = builder.namespace;
        this.namespaceDelimiter = builder.namespaceDelimiter;
        this.name = builder.name;
        this.declarationFile = builder.declarationFile;
        this.definitionFile = !builder.definitionFile.isEmpty() ? builder.definitionFile : this.declarationFile;
        this.references = ListUtils.copyOf((Collection)builder.references);
        this.dependencies = ListUtils.copyOf((Collection)builder.dependencies);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNamespaceDelimiter() {
        return this.namespaceDelimiter;
    }

    public String getName() {
        return this.name;
    }

    public String getDeclarationFile() {
        return this.declarationFile;
    }

    public String getDefinitionFile() {
        return this.definitionFile;
    }

    public String getFullName() {
        return this.toString();
    }

    public String relativize(String namespace) {
        return this.namespace.equals(namespace) ? this.name : this.toString();
    }

    public List<SymbolReference> getReferences() {
        return this.references;
    }

    public List<SymbolDependency> getDependencies() {
        return this.dependencies;
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        return ((Builder)builder.namespace(this.namespace, this.namespaceDelimiter).name(this.name).properties(this.getProperties())).definitionFile(this.definitionFile).declarationFile(this.declarationFile).references(this.references).dependencies(this.dependencies);
    }

    public String toString() {
        return this.namespace.isEmpty() ? this.name : this.namespace + this.namespaceDelimiter + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Symbol)) {
            return false;
        }
        Symbol symbol = (Symbol)o;
        return Objects.equals(this.namespace, symbol.namespace) && Objects.equals(this.namespaceDelimiter, symbol.namespaceDelimiter) && Objects.equals(this.name, symbol.name) && this.getProperties().equals(symbol.getProperties()) && Objects.equals(this.declarationFile, symbol.declarationFile) && Objects.equals(this.definitionFile, symbol.definitionFile) && this.references.equals(symbol.references) && this.dependencies.equals(symbol.dependencies);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.namespaceDelimiter, this.name);
    }

    public static final class Builder
    extends TypedPropertiesBag.Builder<Builder>
    implements SmithyBuilder<Symbol> {
        private String name;
        private String namespace = "";
        private String namespaceDelimiter = "";
        private String definitionFile = "";
        private String declarationFile = "";
        private final List<SymbolReference> references = new ArrayList<SymbolReference>();
        private final List<SymbolDependency> dependencies = new ArrayList<SymbolDependency>();

        public Symbol build() {
            return new Symbol(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder namespace(String namespace, String namespaceDelimiter) {
            this.namespace = namespace == null ? "" : namespace;
            this.namespaceDelimiter = namespaceDelimiter == null ? "" : namespaceDelimiter;
            return this;
        }

        public Builder definitionFile(String definitionFile) {
            this.definitionFile = definitionFile;
            return this;
        }

        public Builder declarationFile(String declarationFile) {
            this.declarationFile = declarationFile;
            return this;
        }

        public Builder references(List<SymbolReference> references) {
            this.references.clear();
            references.forEach(this::addReference);
            return this;
        }

        public Builder addReference(Symbol reference) {
            return this.addReference(new SymbolReference(reference, new SymbolReference.Option[0]));
        }

        public Builder addReference(SymbolReference reference) {
            this.references.add(Objects.requireNonNull(reference));
            return this;
        }

        public Builder dependencies(List<SymbolDependency> dependencies) {
            this.dependencies.clear();
            dependencies.forEach(this::addDependency);
            return this;
        }

        public Builder addDependency(SymbolDependency dependency) {
            this.dependencies.add(dependency);
            return this;
        }

        public Builder addDependency(String packageName, String version) {
            return this.addDependency(null, packageName, version);
        }

        public Builder addDependency(String dependencyType, String packageName, String version) {
            return this.addDependency(SymbolDependency.builder().dependencyType(dependencyType).packageName(packageName).version(version).build());
        }
    }
}

