/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.smithy.codegen.core.SymbolReference;
import software.amazon.smithy.codegen.core.TypedPropertiesBag;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Symbol
extends TypedPropertiesBag
implements ToSmithyBuilder<Symbol> {
    private final String namespace;
    private final String namespaceDelimiter;
    private final String name;
    private final String definitionFile;
    private final String declarationFile;
    private final List<SymbolReference> references;

    private Symbol(Builder builder) {
        super(builder.properties);
        this.namespace = builder.namespace;
        this.namespaceDelimiter = builder.namespaceDelimiter;
        this.name = builder.name;
        this.declarationFile = builder.declarationFile;
        this.definitionFile = !builder.definitionFile.isEmpty() ? builder.definitionFile : this.declarationFile;
        this.references = ListUtils.copyOf((Collection)builder.references);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNamespaceDelimiter() {
        return this.namespaceDelimiter;
    }

    public String getName() {
        return this.name;
    }

    public String getDeclarationFile() {
        return this.declarationFile;
    }

    public String getDefinitionFile() {
        return this.definitionFile;
    }

    public String getFullName() {
        return this.toString();
    }

    public String relativize(String namespace) {
        return this.namespace.equals(namespace) ? this.name : this.toString();
    }

    public List<SymbolReference> getReferences() {
        return this.references;
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        return builder.namespace(this.namespace, this.namespaceDelimiter).name(this.name).properties(this.getProperties()).definitionFile(this.definitionFile).declarationFile(this.declarationFile).references(this.references);
    }

    public String toString() {
        return this.namespace.isEmpty() ? this.name : this.namespace + this.namespaceDelimiter + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Symbol)) {
            return false;
        }
        Symbol symbol = (Symbol)o;
        return Objects.equals(this.namespace, symbol.namespace) && Objects.equals(this.namespaceDelimiter, symbol.namespaceDelimiter) && Objects.equals(this.name, symbol.name) && this.getProperties().equals(symbol.getProperties()) && Objects.equals(this.declarationFile, symbol.declarationFile) && Objects.equals(this.definitionFile, symbol.definitionFile) && this.references.equals(symbol.references);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.namespaceDelimiter, this.name);
    }

    public static final class Builder
    implements SmithyBuilder<Symbol> {
        private String name;
        private String namespace = "";
        private String namespaceDelimiter = "";
        private String definitionFile = "";
        private String declarationFile = "";
        private Map<String, Object> properties = new HashMap<String, Object>();
        private List<SymbolReference> references = new ArrayList<SymbolReference>();

        public Symbol build() {
            return new Symbol(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder namespace(String namespace, String namespaceDelimiter) {
            this.namespace = namespace == null ? "" : namespace;
            this.namespaceDelimiter = namespaceDelimiter == null ? "" : namespaceDelimiter;
            return this;
        }

        public Builder putProperty(String key, Object value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder removeProperty(String key) {
            this.properties.remove(key);
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.properties.clear();
            this.properties.putAll(properties);
            return this;
        }

        public Builder definitionFile(String definitionFile) {
            this.definitionFile = definitionFile;
            return this;
        }

        public Builder declarationFile(String declarationFile) {
            this.declarationFile = declarationFile;
            return this;
        }

        public Builder references(List<SymbolReference> references) {
            this.references.clear();
            references.forEach(this::addReference);
            return this;
        }

        public Builder addReference(Symbol reference) {
            return this.addReference(new SymbolReference(reference, new SymbolReference.Option[0]));
        }

        public Builder addReference(SymbolReference reference) {
            this.references.add(Objects.requireNonNull(reference));
            return this;
        }
    }
}

