/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.wire;

import java.util.HashSet;
import java.util.Set;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.Logs;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.DependencyVerifier;
import software.amazon.smithy.cli.shaded.google.inject.Binder;
import software.amazon.smithy.cli.shaded.google.inject.Binding;
import software.amazon.smithy.cli.shaded.google.inject.Key;
import software.amazon.smithy.cli.shaded.google.inject.spi.BindingTargetVisitor;
import software.amazon.smithy.cli.shaded.google.inject.spi.DefaultElementVisitor;
import software.amazon.smithy.cli.shaded.google.inject.spi.Element;

final class ElementMerger
extends DefaultElementVisitor<Void> {
    private final DependencyVerifier verifier = new DependencyVerifier();
    private final Set<Key<?>> localKeys = new HashSet();
    private final Binder binder;

    ElementMerger(Binder binder) {
        this.binder = binder;
    }

    public <T> Void visit(Binding<T> binding) {
        Key key = binding.getKey();
        if (!this.localKeys.contains(key)) {
            if (Boolean.TRUE.equals(binding.acceptTargetVisitor((BindingTargetVisitor)this.verifier))) {
                this.localKeys.add(key);
                binding.applyTo(this.binder);
            } else {
                Logs.trace("Discard binding: {}", binding, null);
            }
        }
        return null;
    }

    public Void visitOther(Element element) {
        element.applyTo(this.binder);
        return null;
    }
}

