/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.ColorBuffer;
import software.amazon.smithy.cli.ColorTheme;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.HelpPrinter;
import software.amazon.smithy.cli.Style;
import software.amazon.smithy.cli.commands.HelpActionWrapper;
import software.amazon.smithy.model.loader.IdlTokenizer;
import software.amazon.smithy.syntax.Formatter;
import software.amazon.smithy.syntax.TokenTree;
import software.amazon.smithy.utils.IoUtils;

final class FormatCommand
implements Command {
    private final String parentCommandName;

    FormatCommand(String parentCommandName) {
        this.parentCommandName = parentCommandName;
    }

    @Override
    public String getName() {
        return "format";
    }

    @Override
    public String getSummary() {
        return "Formats Smithy IDL models.";
    }

    @Override
    public int execute(Arguments arguments, Command.Env env) {
        arguments.addReceiver(new Options());
        HelpActionWrapper action = HelpActionWrapper.fromCommand(this, this.parentCommandName, c -> {
            ColorBuffer buffer = ColorBuffer.of(c, new StringBuilder());
            buffer.println("Examples:", new Style[0]);
            buffer.println("   smithy format model-file.smithy", ColorTheme.LITERAL);
            buffer.println("   smithy format model/", ColorTheme.LITERAL);
            buffer.println("   smithy format model-file.smithy model/", ColorTheme.LITERAL);
            return buffer.toString();
        }, this::run);
        return action.apply(arguments, env);
    }

    private int run(Arguments arguments, Command.Env env) {
        if (arguments.getPositional().isEmpty()) {
            throw new CliError("No .smithy model or directory was provided as a positional argument");
        }
        ArrayList<Path> paths = new ArrayList<Path>(arguments.getPositional().size());
        for (String filename : arguments.getPositional()) {
            Path path = Paths.get(filename, new String[0]);
            paths.add(path);
            if (Files.isRegularFile(path, new LinkOption[0])) {
                if (filename.endsWith(".smithy")) continue;
                throw new CliError("`" + filename + "` is not a .smithy model file");
            }
            if (Files.isDirectory(path, new LinkOption[0])) continue;
            throw new CliError("`" + filename + "` is not a valid file or directory");
        }
        paths.forEach(this::formatFile);
        return 0;
    }

    private void formatFile(Path file) {
        if (Files.isDirectory(file, new LinkOption[0])) {
            try {
                Files.find(file, 100, (p, a) -> a.isRegularFile(), new FileVisitOption[0]).forEach(this::formatFile);
            }
            catch (IOException e) {
                throw new CliError("Error formatting " + file + " (directory): " + e.getMessage());
            }
        }
        if (Files.isRegularFile(file, new LinkOption[0]) && file.toString().endsWith(".smithy")) {
            TokenTree tree = this.parse(file);
            String formatted = Formatter.format((TokenTree)tree);
            try (OutputStream s = Files.newOutputStream(file, StandardOpenOption.TRUNCATE_EXISTING);){
                s.write(formatted.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new CliError("Error formatting " + file + " (file): " + e.getMessage());
            }
        }
    }

    private TokenTree parse(Path file) {
        String contents = IoUtils.readUtf8File((Path)file);
        IdlTokenizer tokenizer = IdlTokenizer.create((String)file.toString(), (CharSequence)contents);
        return TokenTree.of((IdlTokenizer)tokenizer);
    }

    private static final class Options
    implements ArgumentReceiver {
        private Options() {
        }

        @Override
        public void registerHelp(HelpPrinter printer) {
            printer.positional("<MODELS>", "`.smithy` model files and directories of model files to recursively format.");
        }
    }
}

