/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.google.gson;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import software.amazon.smithy.cli.shaded.google.errorprone.annotations.InlineMe;
import software.amazon.smithy.cli.shaded.google.gson.JsonElement;
import software.amazon.smithy.cli.shaded.google.gson.JsonIOException;
import software.amazon.smithy.cli.shaded.google.gson.JsonParseException;
import software.amazon.smithy.cli.shaded.google.gson.JsonSyntaxException;
import software.amazon.smithy.cli.shaded.google.gson.Strictness;
import software.amazon.smithy.cli.shaded.google.gson.internal.Streams;
import software.amazon.smithy.cli.shaded.google.gson.stream.JsonReader;
import software.amazon.smithy.cli.shaded.google.gson.stream.JsonToken;
import software.amazon.smithy.cli.shaded.google.gson.stream.MalformedJsonException;

public final class JsonParser {
    @Deprecated
    public JsonParser() {
    }

    public static JsonElement parseString(String json) throws JsonSyntaxException {
        return JsonParser.parseReader(new StringReader(json));
    }

    public static JsonElement parseReader(Reader reader) throws JsonIOException, JsonSyntaxException {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            JsonElement element = JsonParser.parseReader(jsonReader);
            if (!element.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return element;
        }
        catch (NumberFormatException | MalformedJsonException e) {
            throw new JsonSyntaxException(e);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    public static JsonElement parseReader(JsonReader reader) throws JsonIOException, JsonSyntaxException {
        Strictness strictness = reader.getStrictness();
        if (strictness == Strictness.LEGACY_STRICT) {
            reader.setStrictness(Strictness.LENIENT);
        }
        try {
            JsonElement jsonElement = Streams.parse(reader);
            return jsonElement;
        }
        catch (OutOfMemoryError | StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source: " + reader + " to Json", e);
        }
        finally {
            reader.setStrictness(strictness);
        }
    }

    @Deprecated
    @InlineMe(replacement="JsonParser.parseString(json)", imports={"software.amazon.smithy.cli.shaded.google.gson.JsonParser"})
    public JsonElement parse(String json) throws JsonSyntaxException {
        return JsonParser.parseString(json);
    }

    @Deprecated
    @InlineMe(replacement="JsonParser.parseReader(json)", imports={"software.amazon.smithy.cli.shaded.google.gson.JsonParser"})
    public JsonElement parse(Reader json) throws JsonIOException, JsonSyntaxException {
        return JsonParser.parseReader(json);
    }

    @Deprecated
    @InlineMe(replacement="JsonParser.parseReader(json)", imports={"software.amazon.smithy.cli.shaded.google.gson.JsonParser"})
    public JsonElement parse(JsonReader json) throws JsonIOException, JsonSyntaxException {
        return JsonParser.parseReader(json);
    }
}

