/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.wire;

import java.util.Arrays;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.ElementAnalyzer;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.FileTypeConverter;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.LocatorWiring;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.PathTypeConverter;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.URLTypeConverter;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.Wiring;
import software.amazon.smithy.cli.shaded.google.inject.Binder;
import software.amazon.smithy.cli.shaded.google.inject.Module;
import software.amazon.smithy.cli.shaded.google.inject.spi.Element;
import software.amazon.smithy.cli.shaded.google.inject.spi.ElementVisitor;
import software.amazon.smithy.cli.shaded.google.inject.spi.Elements;

public final class WireModule
implements Module {
    static final Module[] CONVERTERS = new Module[]{new FileTypeConverter(), new PathTypeConverter(), new URLTypeConverter()};
    private final Iterable<Module> modules;
    private Strategy strategy = Strategy.DEFAULT;

    public WireModule(Module ... modules) {
        this(Arrays.asList(modules));
    }

    public WireModule(Iterable<Module> modules) {
        this.modules = modules;
    }

    public Module with(Strategy _strategy) {
        this.strategy = _strategy;
        return this;
    }

    public void configure(Binder binder) {
        ElementAnalyzer analyzer = new ElementAnalyzer(binder);
        for (Element e : Elements.getElements(this.modules)) {
            e.acceptVisitor((ElementVisitor)analyzer);
        }
        analyzer.apply(this.strategy);
    }

    public static interface Strategy {
        public static final Strategy DEFAULT = new Strategy(){

            @Override
            public Wiring wiring(Binder binder) {
                for (Module m : CONVERTERS) {
                    m.configure(binder);
                }
                return new LocatorWiring(binder);
            }
        };

        public Wiring wiring(Binder var1);
    }
}

