/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.wire;

import java.util.Arrays;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.DefaultBeanLocator;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.ElementAnalyzer;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.WireModule;
import software.amazon.smithy.cli.shaded.google.inject.Binder;
import software.amazon.smithy.cli.shaded.google.inject.Injector;
import software.amazon.smithy.cli.shaded.google.inject.Module;
import software.amazon.smithy.cli.shaded.google.inject.spi.Element;
import software.amazon.smithy.cli.shaded.google.inject.spi.ElementVisitor;
import software.amazon.smithy.cli.shaded.google.inject.spi.Elements;

public final class ChildWireModule
implements Module {
    private final Injector parent;
    private final Iterable<Module> modules;
    private WireModule.Strategy strategy = WireModule.Strategy.DEFAULT;

    public ChildWireModule(Injector parent, Module ... modules) {
        this(parent, Arrays.asList(modules));
    }

    public ChildWireModule(Injector parent, Iterable<Module> modules) {
        this.modules = modules;
        this.parent = parent;
    }

    public Module with(WireModule.Strategy _strategy) {
        this.strategy = _strategy;
        return this;
    }

    public void configure(Binder binder) {
        binder.requestStaticInjection(new Class[]{DefaultBeanLocator.class});
        ElementAnalyzer analyzer = new ElementAnalyzer(binder);
        for (Injector i = this.parent; i != null; i = i.getParent()) {
            analyzer.ignoreKeys(i.getAllBindings().keySet());
        }
        for (Element e : Elements.getElements(this.modules)) {
            e.acceptVisitor((ElementVisitor)analyzer);
        }
        analyzer.apply(this.strategy);
    }
}

