/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.Style;

public final class ColorBuffer
implements Appendable,
AutoCloseable {
    private final ColorFormatter colors;
    private final Appendable buffer;
    private final Consumer<Appendable> closer;

    private ColorBuffer(ColorFormatter colors, Appendable buffer, Consumer<Appendable> closer) {
        this.colors = Objects.requireNonNull(colors);
        this.buffer = Objects.requireNonNull(buffer);
        this.closer = Objects.requireNonNull(closer);
    }

    public static ColorBuffer of(ColorFormatter colors, Appendable sink) {
        return new ColorBuffer(colors, sink, s -> {});
    }

    public static ColorBuffer of(ColorFormatter colors, CliPrinter sink) {
        StringBuilder buffer = new StringBuilder();
        return new ColorBuffer(colors, buffer, s -> sink.append(s.toString()));
    }

    public String toString() {
        return this.buffer.toString();
    }

    @Override
    public ColorBuffer append(CharSequence csq) {
        try {
            this.buffer.append(csq);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    @Override
    public ColorBuffer append(CharSequence csq, int start, int end) {
        try {
            this.buffer.append(csq, start, end);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    @Override
    public ColorBuffer append(char c) {
        try {
            this.buffer.append(c);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    public ColorBuffer print(String text, Style ... styles) {
        this.colors.style(this.buffer, text, styles);
        return this;
    }

    public ColorBuffer println(String text, Style ... styles) {
        return this.print(text, styles).append(System.lineSeparator());
    }

    public ColorBuffer println() {
        return this.append(System.lineSeparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorBuffer style(Consumer<ColorBuffer> bufferConsumer, Style ... styles) {
        try {
            this.colors.startStyle(this.buffer, styles);
            bufferConsumer.accept(this);
            ColorBuffer colorBuffer = this;
            return colorBuffer;
        }
        finally {
            if (styles.length > 0) {
                this.colors.endStyle(this.buffer);
            }
        }
    }

    @Override
    public void close() {
        this.closer.accept(this.buffer);
    }
}

