/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.wire;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;

public final class EntrySetAdapter<V>
extends AbstractSet<V> {
    private final Iterable<? extends Map.Entry<?, V>> iterable;

    public EntrySetAdapter(Iterable<? extends Map.Entry<?, V>> iterable) {
        this.iterable = iterable;
    }

    @Override
    public Iterator<V> iterator() {
        return new ValueIterator(this.iterable);
    }

    @Override
    public boolean isEmpty() {
        return false == this.iterator().hasNext();
    }

    @Override
    public int size() {
        int size = 0;
        Iterator<Map.Entry<?, V>> i = this.iterable.iterator();
        while (i.hasNext()) {
            ++size;
            i.next();
        }
        return size;
    }

    private static final class ValueIterator<V>
    implements Iterator<V> {
        private final Iterator<? extends Map.Entry<?, V>> iterator;

        ValueIterator(Iterable<? extends Map.Entry<?, V>> iterable) {
            this.iterator = iterable.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return this.iterator.next().getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

