/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.inject;

import com.google.inject.ImplementedBy;
import com.google.inject.Key;
import com.google.inject.ProvidedBy;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import software.amazon.smithy.cli.shaded.javax.inject.Qualifier;

public final class TypeArguments {
    private static final TypeLiteral<Object> OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);
    private static final TypeLiteral<?>[] NO_TYPE_LITERALS = new TypeLiteral[0];

    private TypeArguments() {
    }

    public static TypeLiteral<?>[] get(TypeLiteral<?> typeLiteral) {
        Type type = typeLiteral.getType();
        if (type instanceof ParameterizedType) {
            Type[] argumentTypes = ((ParameterizedType)type).getActualTypeArguments();
            TypeLiteral[] argumentLiterals = new TypeLiteral[argumentTypes.length];
            for (int i = 0; i < argumentTypes.length; ++i) {
                argumentLiterals[i] = TypeArguments.expand(argumentTypes[i]);
            }
            return argumentLiterals;
        }
        if (type instanceof GenericArrayType) {
            return new TypeLiteral[]{TypeArguments.expand(((GenericArrayType)type).getGenericComponentType())};
        }
        return NO_TYPE_LITERALS;
    }

    public static TypeLiteral<?> get(TypeLiteral<?> typeLiteral, int index) {
        Type type = typeLiteral.getType();
        if (type instanceof ParameterizedType) {
            return TypeArguments.expand(((ParameterizedType)type).getActualTypeArguments()[index]);
        }
        if (type instanceof GenericArrayType) {
            if (0 == index) {
                return TypeArguments.expand(((GenericArrayType)type).getGenericComponentType());
            }
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return OBJECT_TYPE_LITERAL;
    }

    public static boolean isAssignableFrom(TypeLiteral<?> superLiteral, TypeLiteral<?> subLiteral) {
        Type resolvedType;
        Class superClazz = superLiteral.getRawType();
        if (!superClazz.isAssignableFrom(subLiteral.getRawType())) {
            return false;
        }
        Type superType = superLiteral.getType();
        if (superClazz == superType) {
            return true;
        }
        if (superType instanceof ParameterizedType) {
            Type resolvedType2 = subLiteral.getSupertype(superClazz).getType();
            if (resolvedType2 instanceof ParameterizedType) {
                Type[] superArgs = ((ParameterizedType)superType).getActualTypeArguments();
                Type[] subArgs = ((ParameterizedType)resolvedType2).getActualTypeArguments();
                return TypeArguments.isAssignableFrom(superArgs, subArgs);
            }
        } else if (superType instanceof GenericArrayType && (resolvedType = subLiteral.getSupertype(superClazz).getType()) instanceof GenericArrayType) {
            Type superComponent = ((GenericArrayType)superType).getGenericComponentType();
            Type subComponent = ((GenericArrayType)resolvedType).getGenericComponentType();
            return TypeArguments.isAssignableFrom(new Type[]{superComponent}, new Type[]{subComponent});
        }
        return false;
    }

    public static boolean isConcrete(TypeLiteral<?> literal) {
        return TypeArguments.isConcrete(literal.getRawType());
    }

    public static boolean isConcrete(Class<?> clazz) {
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isImplicit(TypeLiteral<?> literal) {
        return TypeArguments.isImplicit(literal.getRawType());
    }

    public static boolean isImplicit(Class<?> clazz) {
        return TypeArguments.isConcrete(clazz) || clazz.isAnnotationPresent(ImplementedBy.class) || clazz.isAnnotationPresent(ProvidedBy.class);
    }

    public static <T> Key<T> implicitKey(Class<T> clazz) {
        return Key.get(clazz, Implicit.class);
    }

    private static TypeLiteral<?> expand(Type type) {
        if (type instanceof WildcardType) {
            return TypeLiteral.get((Type)((WildcardType)type).getUpperBounds()[0]);
        }
        if (type instanceof TypeVariable) {
            return TypeLiteral.get((Type)((TypeVariable)type).getBounds()[0]);
        }
        return TypeLiteral.get((Type)type);
    }

    private static boolean isAssignableFrom(Type[] superArgs, Type[] subArgs) {
        int len = Math.min(superArgs.length, subArgs.length);
        for (int i = 0; i < len; ++i) {
            Type superType = superArgs[i];
            Type subType = subArgs[i];
            if (subType instanceof TypeVariable && TypeArguments.isAssignableFrom(TypeArguments.expand(subType), TypeArguments.expand(superType)) || !(superType instanceof WildcardType || superType instanceof TypeVariable ? !TypeArguments.isAssignableFrom(TypeArguments.expand(superType), TypeArguments.expand(subType)) : !superType.equals(subType))) continue;
            return false;
        }
        return true;
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Implicit {
    }
}

