/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.RemoteRepository;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.ArtifactDownload;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.ArtifactUpload;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.MetadataDownload;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.MetadataUpload;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.RepositoryConnector;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import software.amazon.smithy.cli.shaded.eclipse.aether.transfer.ArtifactNotFoundException;
import software.amazon.smithy.cli.shaded.eclipse.aether.transfer.MetadataNotFoundException;

public final class FilteringRepositoryConnector
implements RepositoryConnector {
    private final RemoteRepository remoteRepository;
    private final RepositoryConnector delegate;
    private final RemoteRepositoryFilter remoteRepositoryFilter;

    public FilteringRepositoryConnector(RemoteRepository remoteRepository, RepositoryConnector delegate, RemoteRepositoryFilter remoteRepositoryFilter) {
        this.remoteRepository = Objects.requireNonNull(remoteRepository);
        this.delegate = Objects.requireNonNull(delegate);
        this.remoteRepositoryFilter = Objects.requireNonNull(remoteRepositoryFilter);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        ArrayList<ArtifactDownload> filteredArtifactDownloads = null;
        if (artifactDownloads != null && !artifactDownloads.isEmpty()) {
            filteredArtifactDownloads = new ArrayList<ArtifactDownload>(artifactDownloads.size());
            for (ArtifactDownload artifactDownload : artifactDownloads) {
                RemoteRepositoryFilter.Result result = this.remoteRepositoryFilter.acceptArtifact(this.remoteRepository, artifactDownload.getArtifact());
                if (result.isAccepted()) {
                    filteredArtifactDownloads.add(artifactDownload);
                    continue;
                }
                artifactDownload.setException(new ArtifactNotFoundException(artifactDownload.getArtifact(), this.remoteRepository, result.reasoning()));
            }
        }
        ArrayList<MetadataDownload> filteredMetadataDownloads = null;
        if (metadataDownloads != null && !metadataDownloads.isEmpty()) {
            filteredMetadataDownloads = new ArrayList<MetadataDownload>(metadataDownloads.size());
            for (MetadataDownload metadataDownload : metadataDownloads) {
                RemoteRepositoryFilter.Result result = this.remoteRepositoryFilter.acceptMetadata(this.remoteRepository, metadataDownload.getMetadata());
                if (result.isAccepted()) {
                    filteredMetadataDownloads.add(metadataDownload);
                    continue;
                }
                metadataDownload.setException(new MetadataNotFoundException(metadataDownload.getMetadata(), this.remoteRepository, result.reasoning()));
            }
        }
        this.delegate.get(filteredArtifactDownloads, filteredMetadataDownloads);
    }

    @Override
    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        this.delegate.put(artifactUploads, metadataUploads);
    }

    public String toString() {
        return "filtered(" + this.delegate.toString() + ")";
    }
}

