/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.connector.basic;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import software.amazon.smithy.cli.shaded.eclipse.aether.connector.basic.ChecksumCalculator;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.checksum.ChecksumPolicy;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.layout.RepositoryLayout;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.io.FileProcessor;
import software.amazon.smithy.cli.shaded.eclipse.aether.transfer.ChecksumFailureException;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.FileUtils;
import software.amazon.smithy.cli.shaded.slf4j.Logger;
import software.amazon.smithy.cli.shaded.slf4j.LoggerFactory;

final class ChecksumValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChecksumValidator.class);
    private final File dataFile;
    private final Collection<ChecksumAlgorithmFactory> checksumAlgorithmFactories;
    private final FileProcessor fileProcessor;
    private final ChecksumFetcher checksumFetcher;
    private final ChecksumPolicy checksumPolicy;
    private final Map<String, String> providedChecksums;
    private final Collection<RepositoryLayout.ChecksumLocation> checksumLocations;
    private final Map<File, String> checksumExpectedValues;

    ChecksumValidator(File dataFile, Collection<ChecksumAlgorithmFactory> checksumAlgorithmFactories, FileProcessor fileProcessor, ChecksumFetcher checksumFetcher, ChecksumPolicy checksumPolicy, Map<String, String> providedChecksums, Collection<RepositoryLayout.ChecksumLocation> checksumLocations) {
        this.dataFile = dataFile;
        this.checksumAlgorithmFactories = checksumAlgorithmFactories;
        this.fileProcessor = fileProcessor;
        this.checksumFetcher = checksumFetcher;
        this.checksumPolicy = checksumPolicy;
        this.providedChecksums = providedChecksums;
        this.checksumLocations = checksumLocations;
        this.checksumExpectedValues = new HashMap<File, String>();
    }

    public ChecksumCalculator newChecksumCalculator(File targetFile) {
        if (this.checksumPolicy != null) {
            return ChecksumCalculator.newInstance(targetFile, this.checksumAlgorithmFactories);
        }
        return null;
    }

    public void validate(Map<String, ?> actualChecksums, Map<String, ?> includedChecksums) throws ChecksumFailureException {
        if (this.checksumPolicy == null) {
            return;
        }
        if (this.providedChecksums != null && this.validateChecksums(actualChecksums, ChecksumPolicy.ChecksumKind.PROVIDED, this.providedChecksums)) {
            return;
        }
        if (includedChecksums != null && this.validateChecksums(actualChecksums, ChecksumPolicy.ChecksumKind.REMOTE_INCLUDED, includedChecksums)) {
            return;
        }
        if (!this.checksumLocations.isEmpty()) {
            if (this.validateExternalChecksums(actualChecksums)) {
                return;
            }
            this.checksumPolicy.onNoMoreChecksums();
        }
    }

    private boolean validateChecksums(Map<String, ?> actualChecksums, ChecksumPolicy.ChecksumKind kind, Map<String, ?> checksums) throws ChecksumFailureException {
        for (Map.Entry<String, ?> entry : checksums.entrySet()) {
            ChecksumAlgorithmFactory checksumAlgorithmFactory;
            String algo = entry.getKey();
            Object calculated = actualChecksums.get(algo);
            if (!(calculated instanceof String) || (checksumAlgorithmFactory = (ChecksumAlgorithmFactory)this.checksumAlgorithmFactories.stream().filter(a -> a.getName().equals(algo)).findFirst().orElse(null)) == null) continue;
            String actual = String.valueOf(calculated);
            String expected = entry.getValue().toString();
            this.checksumExpectedValues.put(this.getChecksumFile(checksumAlgorithmFactory), expected);
            if (!ChecksumValidator.isEqualChecksum(expected, actual)) {
                this.checksumPolicy.onChecksumMismatch(checksumAlgorithmFactory.getName(), kind, new ChecksumFailureException(expected, kind.name(), actual));
                continue;
            }
            if (!this.checksumPolicy.onChecksumMatch(checksumAlgorithmFactory.getName(), kind)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateExternalChecksums(Map<String, ?> actualChecksums) throws ChecksumFailureException {
        Iterator<RepositoryLayout.ChecksumLocation> iterator = this.checksumLocations.iterator();
        while (iterator.hasNext()) {
            RepositoryLayout.ChecksumLocation checksumLocation = iterator.next();
            ChecksumAlgorithmFactory factory = checksumLocation.getChecksumAlgorithmFactory();
            Object calculated = actualChecksums.get(factory.getName());
            if (calculated instanceof Exception) {
                this.checksumPolicy.onChecksumError(factory.getName(), ChecksumPolicy.ChecksumKind.REMOTE_EXTERNAL, new ChecksumFailureException((Exception)calculated));
                continue;
            }
            File checksumFile = this.getChecksumFile(checksumLocation.getChecksumAlgorithmFactory());
            try {
                File tmp;
                block14: {
                    FileUtils.CollocatedTempFile tempFile = FileUtils.newTempFile(checksumFile.toPath());
                    tmp = tempFile.getPath().toFile();
                    try {
                        if (this.checksumFetcher.fetchChecksum(checksumLocation.getLocation(), tmp)) break block14;
                        if (tempFile == null) continue;
                    }
                    catch (Exception e) {
                        this.checksumPolicy.onChecksumError(factory.getName(), ChecksumPolicy.ChecksumKind.REMOTE_EXTERNAL, new ChecksumFailureException(e));
                        continue;
                    }
                    tempFile.close();
                    continue;
                }
                String actual = String.valueOf(calculated);
                String expected = this.fileProcessor.readChecksum(tmp);
                this.checksumExpectedValues.put(checksumFile, expected);
                if (!ChecksumValidator.isEqualChecksum(expected, actual)) {
                    this.checksumPolicy.onChecksumMismatch(factory.getName(), ChecksumPolicy.ChecksumKind.REMOTE_EXTERNAL, new ChecksumFailureException(expected, ChecksumPolicy.ChecksumKind.REMOTE_EXTERNAL.name(), actual));
                    continue;
                }
                if (!this.checksumPolicy.onChecksumMatch(factory.getName(), ChecksumPolicy.ChecksumKind.REMOTE_EXTERNAL)) continue;
                return true;
            }
            catch (IOException e) {
                this.checksumPolicy.onChecksumError(factory.getName(), ChecksumPolicy.ChecksumKind.REMOTE_EXTERNAL, new ChecksumFailureException(e));
            }
        }
        return false;
    }

    private static boolean isEqualChecksum(String expected, String actual) {
        return expected.equalsIgnoreCase(actual);
    }

    private File getChecksumFile(ChecksumAlgorithmFactory factory) {
        return new File(this.dataFile.getPath() + '.' + factory.getFileExtension());
    }

    public void retry() {
        this.checksumPolicy.onTransferRetry();
        this.checksumExpectedValues.clear();
    }

    public boolean handle(ChecksumFailureException exception) {
        return this.checksumPolicy.onTransferChecksumFailure(exception);
    }

    public void commit() {
        for (Map.Entry<File, String> entry : this.checksumExpectedValues.entrySet()) {
            File checksumFile = entry.getKey();
            try {
                this.fileProcessor.writeChecksum(checksumFile, entry.getValue());
            }
            catch (IOException e) {
                LOGGER.debug("Failed to write checksum file {}", (Object)checksumFile, (Object)e);
                throw new UncheckedIOException(e);
            }
        }
        this.checksumExpectedValues.clear();
    }

    static interface ChecksumFetcher {
        public boolean fetchChecksum(URI var1, File var2) throws Exception;
    }
}

