/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.http.protocol;

import java.io.IOException;
import software.amazon.smithy.cli.shaded.apache.http.HttpException;
import software.amazon.smithy.cli.shaded.apache.http.HttpRequest;
import software.amazon.smithy.cli.shaded.apache.http.HttpRequestInterceptor;
import software.amazon.smithy.cli.shaded.apache.http.annotation.Contract;
import software.amazon.smithy.cli.shaded.apache.http.annotation.ThreadingBehavior;
import software.amazon.smithy.cli.shaded.apache.http.params.HttpParams;
import software.amazon.smithy.cli.shaded.apache.http.protocol.HttpContext;
import software.amazon.smithy.cli.shaded.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

