/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.http.impl.io;

import software.amazon.smithy.cli.shaded.apache.http.HttpRequest;
import software.amazon.smithy.cli.shaded.apache.http.annotation.Contract;
import software.amazon.smithy.cli.shaded.apache.http.annotation.ThreadingBehavior;
import software.amazon.smithy.cli.shaded.apache.http.impl.io.DefaultHttpRequestWriter;
import software.amazon.smithy.cli.shaded.apache.http.io.HttpMessageWriter;
import software.amazon.smithy.cli.shaded.apache.http.io.HttpMessageWriterFactory;
import software.amazon.smithy.cli.shaded.apache.http.io.SessionOutputBuffer;
import software.amazon.smithy.cli.shaded.apache.http.message.BasicLineFormatter;
import software.amazon.smithy.cli.shaded.apache.http.message.LineFormatter;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestWriterFactory
implements HttpMessageWriterFactory<HttpRequest> {
    public static final DefaultHttpRequestWriterFactory INSTANCE = new DefaultHttpRequestWriterFactory();
    private final LineFormatter lineFormatter;

    public DefaultHttpRequestWriterFactory(LineFormatter lineFormatter) {
        this.lineFormatter = lineFormatter != null ? lineFormatter : BasicLineFormatter.INSTANCE;
    }

    public DefaultHttpRequestWriterFactory() {
        this(null);
    }

    @Override
    public HttpMessageWriter<HttpRequest> create(SessionOutputBuffer buffer) {
        return new DefaultHttpRequestWriter(buffer, this.lineFormatter);
    }
}

