/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.Collection;
import java.util.Iterator;
import software.amazon.smithy.cli.ColorBuffer;
import software.amazon.smithy.cli.ColorTheme;
import software.amazon.smithy.model.loader.sourcecontext.SourceContextLoader;

final class CodeFormatter {
    private final ColorBuffer writer;
    private final int maxWidth;

    CodeFormatter(ColorBuffer writer, int maxWidth) {
        this.writer = writer;
        this.maxWidth = maxWidth;
    }

    void writeCode(int cursorLine, int cursorColumn, Collection<SourceContextLoader.Line> lines) {
        if (lines.isEmpty()) {
            return;
        }
        int numberLength = this.findLongestNumber(lines);
        Iterator<SourceContextLoader.Line> lineIterator = lines.iterator();
        int lastLine = -1;
        while (lineIterator.hasNext()) {
            SourceContextLoader.Line line = lineIterator.next();
            if (line.getLineNumber() != lastLine + 1 && lastLine != -1) {
                this.writeColumnAndContent(numberLength, -1, "");
            }
            this.writeColumnAndContent(numberLength, line.getLineNumber(), line.getContent());
            if (line.getLineNumber() == cursorLine) {
                this.writePointer(numberLength, cursorColumn);
            }
            lastLine = line.getLineNumber();
        }
        this.writer.append(System.lineSeparator());
    }

    private void writeColumnAndContent(int numberLength, int lineNumber, CharSequence content) {
        this.writer.style(w -> {
            if (lineNumber == -1) {
                for (int i = 0; i < numberLength; ++i) {
                    this.writer.append("\u00b7");
                }
                this.writer.append("|");
            } else {
                String lineString = String.valueOf(lineNumber);
                int thisLineLength = lineString.length();
                this.writer.append(lineString);
                for (int i = 0; i < numberLength - thisLineLength; ++i) {
                    this.writer.append(' ');
                }
                this.writer.append("| ");
            }
        }, ColorTheme.MUTED);
        if (content.length() > 0) {
            this.writeStringWithMaxWidth(content, numberLength);
        }
        this.writer.println();
    }

    private void writePointer(int numberLength, int cursorColumn) {
        this.writer.style(w -> {
            for (int j = 0; j < numberLength; ++j) {
                w.append(' ');
            }
            w.append("|");
        }, ColorTheme.MUTED);
        for (int j = 0; j < cursorColumn; ++j) {
            this.writer.append(' ');
        }
        this.writer.print("^", ColorTheme.ERROR);
        this.writer.println();
    }

    private int findLongestNumber(Collection<SourceContextLoader.Line> lines) {
        int maxLineNumber = 1;
        for (SourceContextLoader.Line line : lines) {
            maxLineNumber = line.getLineNumber();
        }
        return String.valueOf(maxLineNumber).length();
    }

    private void writeStringWithMaxWidth(CharSequence line, int offsetSize) {
        int allowedSize = this.maxWidth - offsetSize;
        this.writer.append(line, 0, Math.min(line.length(), allowedSize));
        if (line.length() >= allowedSize) {
            this.writer.append("\u2026");
        }
    }
}

