/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.build.ProjectionResult;
import software.amazon.smithy.build.SmithyBuild;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.ColorBuffer;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.ColorTheme;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.HelpPrinter;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.cli.Style;
import software.amazon.smithy.cli.commands.BuildOptions;
import software.amazon.smithy.cli.commands.ClasspathAction;
import software.amazon.smithy.cli.commands.ConfigOptions;
import software.amazon.smithy.cli.commands.DiscoveryOptions;
import software.amazon.smithy.cli.commands.HelpActionWrapper;
import software.amazon.smithy.cli.commands.ModelBuilder;
import software.amazon.smithy.cli.commands.PrettyAnsiValidationFormatter;
import software.amazon.smithy.cli.commands.SeverityOption;
import software.amazon.smithy.cli.dependencies.DependencyResolver;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.loader.sourcecontext.SourceContextLoader;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

final class BuildCommand
implements Command {
    private final String parentCommandName;
    private final DependencyResolver.Factory dependencyResolverFactory;

    BuildCommand(String parentCommandName, DependencyResolver.Factory dependencyResolverFactory) {
        this.parentCommandName = parentCommandName;
        this.dependencyResolverFactory = dependencyResolverFactory;
    }

    @Override
    public String getName() {
        return "build";
    }

    @Override
    public String getSummary() {
        return "Builds Smithy models and creates plugin artifacts for each projection found in smithy-build.json.";
    }

    @Override
    public int execute(Arguments arguments, Command.Env env) {
        arguments.addReceiver(new ConfigOptions());
        arguments.addReceiver(new DiscoveryOptions());
        arguments.addReceiver(new SeverityOption());
        arguments.addReceiver(new BuildOptions());
        arguments.addReceiver(new Options());
        HelpActionWrapper action = HelpActionWrapper.fromCommand(this, this.parentCommandName, new ClasspathAction(this.dependencyResolverFactory, this::runWithClassLoader));
        return action.apply(arguments, env);
    }

    private int runWithClassLoader(SmithyBuildConfig config, Arguments arguments, Command.Env env) {
        List<String> models = arguments.getPositional();
        Options options = arguments.getReceiver(Options.class);
        BuildOptions buildOptions = arguments.getReceiver(BuildOptions.class);
        StandardOptions standardOptions = arguments.getReceiver(StandardOptions.class);
        ClassLoader classLoader = env.classLoader();
        Model model = new ModelBuilder().config(config).arguments(arguments).env(env).models(models).validationPrinter(env.stderr()).build();
        if (!standardOptions.quiet()) {
            env.colors().println(env.stderr(), "Validated model, now starting projections...", ColorTheme.MUTED);
            env.stderr().println("");
        }
        Supplier<ModelAssembler> modelAssemblerSupplier = () -> {
            ModelAssembler assembler = Model.assembler((ClassLoader)classLoader);
            if (buildOptions.allowUnknownTraits()) {
                assembler.putProperty("assembler.allowUnknownTraits", (Object)true);
            }
            return assembler;
        };
        SmithyBuild smithyBuild = SmithyBuild.create((ClassLoader)classLoader, modelAssemblerSupplier).config(config).model(model);
        if (buildOptions.output() != null) {
            smithyBuild.outputDirectory(buildOptions.output());
        }
        if (options.plugin != null) {
            smithyBuild.pluginFilter(name -> name.equals(options.plugin));
        }
        if (options.projection != null) {
            smithyBuild.projectionFilter(name -> name.equals(options.projection));
        }
        models.forEach(path -> smithyBuild.registerSources(new Path[]{Paths.get(path, new String[0])}));
        ResultConsumer resultConsumer = new ResultConsumer(env.colors(), env.stderr(), standardOptions.quiet());
        smithyBuild.build((Consumer)resultConsumer, (BiConsumer)resultConsumer);
        env.flush();
        if (!standardOptions.quiet()) {
            try (ColorBuffer buffer = ColorBuffer.of(env.colors(), env.stderr());){
                buffer.print("Summary", ColorTheme.EM_UNDERLINE);
                buffer.println(String.format(": Smithy built %s projection(s), %s plugin(s), and %s artifacts", resultConsumer.projectionCount, resultConsumer.pluginCount, resultConsumer.artifactCount), new Style[0]);
            }
        }
        if (!resultConsumer.failedProjections.isEmpty()) {
            resultConsumer.failedProjections.sort(String::compareTo);
            StringBuilder error = new StringBuilder();
            try (ColorBuffer buffer = ColorBuffer.of(env.colors(), error);){
                buffer.println();
                buffer.println(String.format("The following %d Smithy build projection(s) failed: %s", resultConsumer.failedProjections.size(), resultConsumer.failedProjections), new Style[0]);
            }
            throw new CliError(error.toString());
        }
        return 0;
    }

    private static final class Options
    implements ArgumentReceiver {
        private String projection;
        private String plugin;

        private Options() {
        }

        @Override
        public Consumer<String> testParameter(String name) {
            switch (name) {
                case "--projection": {
                    return value -> {
                        this.projection = value;
                    };
                }
                case "--plugin": {
                    return value -> {
                        this.plugin = value;
                    };
                }
            }
            return null;
        }

        @Override
        public void registerHelp(HelpPrinter printer) {
            printer.param("--projection", null, "PROJECTION_NAME", "Only generate artifacts for this projection.");
            printer.param("--plugin", null, "PLUGIN_NAME", "Only generate artifacts for this plugin.");
        }
    }

    private static final class ResultConsumer
    implements Consumer<ProjectionResult>,
    BiConsumer<String, Throwable> {
        private final List<String> failedProjections = Collections.synchronizedList(new ArrayList());
        private final AtomicInteger artifactCount = new AtomicInteger();
        private final AtomicInteger pluginCount = new AtomicInteger();
        private final AtomicInteger projectionCount = new AtomicInteger();
        private final boolean quiet;
        private final ColorFormatter colors;
        private final CliPrinter printer;

        ResultConsumer(ColorFormatter colors, CliPrinter stderr, boolean quiet) {
            this.colors = colors;
            this.printer = stderr;
            this.quiet = quiet;
        }

        @Override
        public void accept(String name, Throwable exception) {
            this.failedProjections.add(name);
            StringWriter writer = new StringWriter();
            writer.write(String.format("%nProjection %s failed: %s%n", name, exception.toString()));
            exception.printStackTrace(new PrintWriter(writer));
            this.colors.println(this.printer, writer.toString(), ColorTheme.ERROR);
        }

        @Override
        public void accept(ProjectionResult result) {
            try (ColorBuffer buffer = ColorBuffer.of(this.colors, this.printer);){
                Path root;
                String status;
                Style statusStyle;
                if (result.isBroken()) {
                    this.failedProjections.add(result.getProjectionName());
                    statusStyle = ColorTheme.ERROR;
                    status = "Failed";
                } else {
                    this.projectionCount.incrementAndGet();
                    statusStyle = ColorTheme.SUCCESS;
                    status = "Completed";
                }
                this.pluginCount.addAndGet(result.getPluginManifests().size());
                for (FileManifest manifest : result.getPluginManifests().values()) {
                    this.artifactCount.addAndGet(manifest.getFiles().size());
                }
                Iterator manifestIterator = result.getPluginManifests().values().iterator();
                Path path = root = manifestIterator.hasNext() ? ((FileManifest)manifestIterator.next()).getBaseDir().getParent() : null;
                if (!this.quiet) {
                    int remainingLength = 74 - result.getProjectionName().length();
                    buffer.style(w -> {
                        w.append("\u2500\u2500  ");
                        w.append(result.getProjectionName());
                        w.append("  ");
                        for (int i = 0; i < remainingLength; ++i) {
                            w.append("\u2500");
                        }
                        w.println();
                    }, statusStyle);
                    buffer.print(status, new Style[0]).append(" projection ").append(result.getProjectionName()).append(" (").append(String.valueOf(result.getModel().toSet().size())).append("): ").append(String.valueOf(root)).println();
                }
                if (result.isBroken()) {
                    SourceContextLoader loader = SourceContextLoader.createModelAwareLoader((Model)result.getModel(), (int)4);
                    PrettyAnsiValidationFormatter formatter = PrettyAnsiValidationFormatter.builder().sourceContextLoader(loader).colors(this.colors).titleLabel(result.getProjectionName(), statusStyle).build();
                    result.getEvents().forEach(event -> {
                        if (event.getSeverity() == Severity.DANGER || event.getSeverity() == Severity.ERROR) {
                            buffer.println(formatter.format((ValidationEvent)event), new Style[0]);
                        }
                    });
                }
                buffer.println();
            }
        }
    }
}

