/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.regex.Pattern;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.ColorTheme;
import software.amazon.smithy.utils.StringUtils;

final class StyleHelper {
    private static final Pattern TICK_PATTERN = Pattern.compile("`(.*?)`");

    private StyleHelper() {
    }

    static String formatMessage(String message, int lineLength, ColorFormatter colors) {
        String content = StringUtils.wrap((String)message, (int)lineLength, (String)System.lineSeparator(), (boolean)false);
        if (colors.isColorEnabled()) {
            content = StyleHelper.markdownLiterals(content, colors);
        }
        return content;
    }

    static String markdownLiterals(String content, ColorFormatter colors) {
        if (colors.isColorEnabled()) {
            content = TICK_PATTERN.matcher(content).replaceAll(colors.style("$1", ColorTheme.LITERAL));
        }
        return content;
    }
}

