/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.EnvironmentVariable;
import software.amazon.smithy.cli.Style;

public enum AnsiColorFormatter implements ColorFormatter
{
    NO_COLOR{

        @Override
        public boolean isColorEnabled() {
            return false;
        }

        @Override
        public void startStyle(Appendable appendable, Style ... style) {
        }

        @Override
        public void endStyle(Appendable appendable) {
        }
    }
    ,
    FORCE_COLOR{

        @Override
        public boolean isColorEnabled() {
            return true;
        }

        @Override
        public void startStyle(Appendable appendable, Style ... styles) {
            if (styles.length > 0) {
                try {
                    appendable.append("\u001b[");
                    boolean isAfterFirst = false;
                    for (Style style : styles) {
                        if (isAfterFirst) {
                            appendable.append(';');
                        }
                        appendable.append(style.getAnsiColorCode());
                        isAfterFirst = true;
                    }
                    appendable.append('m');
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        @Override
        public void endStyle(Appendable appendable) {
            try {
                appendable.append("\u001b[0m");
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
    ,
    AUTO{
        private final AnsiColorFormatter delegate = AnsiColorFormatter.detect();

        @Override
        public String style(String text, Style ... styles) {
            return this.delegate.style(text, styles);
        }

        @Override
        public void println(Appendable appendable, String text, Style ... styles) {
            this.delegate.println(appendable, text, styles);
        }

        @Override
        public void style(Appendable appendable, String text, Style ... styles) {
            this.delegate.style(appendable, text, styles);
        }

        @Override
        public boolean isColorEnabled() {
            return this.delegate.isColorEnabled();
        }

        @Override
        public void startStyle(Appendable appendable, Style ... style) {
            this.delegate.startStyle(appendable, style);
        }

        @Override
        public void endStyle(Appendable appendable) {
            this.delegate.endStyle(appendable);
        }
    };


    public static AnsiColorFormatter detect() {
        return AnsiColorFormatter.isAnsiEnabled() ? FORCE_COLOR : NO_COLOR;
    }

    private static boolean isAnsiEnabled() {
        if (EnvironmentVariable.FORCE_COLOR.isSet()) {
            return true;
        }
        if (EnvironmentVariable.NO_COLOR.isSet()) {
            return false;
        }
        String term = EnvironmentVariable.TERM.get();
        if (Objects.equals(term, "dumb")) {
            return false;
        }
        if (term == null && System.getProperty("os.name").contains("win")) {
            return false;
        }
        return System.console() != null;
    }
}

