/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.function.Consumer;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.HelpPrinter;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.model.validation.Severity;

final class SeverityOption
implements ArgumentReceiver {
    static final String SEVERITY = "--severity";
    private Severity severity;

    SeverityOption() {
    }

    @Override
    public void registerHelp(HelpPrinter printer) {
        printer.param(SEVERITY, null, "SEVERITY", "Set the minimum reported validation severity (one of NOTE, WARNING [default setting], DANGER, ERROR).");
    }

    @Override
    public Consumer<String> testParameter(String name) {
        if (SEVERITY.equals(name)) {
            return value -> this.severity((Severity)Severity.fromString((String)value).orElseThrow(() -> new CliError("Invalid severity level: " + value)));
        }
        return null;
    }

    void severity(Severity severity) {
        this.severity = severity;
    }

    Severity severity(StandardOptions options) {
        if (this.severity != null) {
            return this.severity;
        }
        if (options.quiet()) {
            return Severity.DANGER;
        }
        return Severity.WARNING;
    }
}

