/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.Style;
import software.amazon.smithy.utils.StringUtils;

public final class HelpPrinter {
    private final String name;
    private int maxWidth = 80;
    private String summary;
    private String documentation;
    private final List<Arg> args = new ArrayList<Arg>();
    private Arg positional;

    public HelpPrinter(String name) {
        this.name = name;
    }

    public HelpPrinter maxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public static HelpPrinter fromArguments(String name, Arguments arguments) {
        HelpPrinter printer = new HelpPrinter(name);
        for (ArgumentReceiver receiver : arguments.getReceivers()) {
            receiver.registerHelp(printer);
        }
        return printer;
    }

    public HelpPrinter summary(String summary) {
        this.summary = summary;
        return this;
    }

    public HelpPrinter documentation(String documentation) {
        this.documentation = documentation;
        return this;
    }

    public HelpPrinter option(String longName, String shortName, String description) {
        this.args.add(Arg.option(longName, shortName, description));
        return this;
    }

    public HelpPrinter param(String longName, String shortName, String exampleValue, String description) {
        this.args.add(Arg.parameter(longName, shortName, exampleValue, description));
        return this;
    }

    public HelpPrinter positional(String name, String description) {
        this.positional = Arg.positional(name, description);
        return this;
    }

    public void print(ColorFormatter colors, CliPrinter printer) {
        LineWrapper builder = new LineWrapper(this.maxWidth);
        builder.appendWithinLine("Usage: ").appendWithinLine(colors.style(this.name, Style.BRIGHT_WHITE, Style.UNDERLINE)).space();
        builder.indent("Usage: ".length() + this.name.length() + 1);
        for (Arg arg : this.args) {
            builder.appendWithinLine(arg.toShortArgs(colors)).space();
        }
        if (this.positional != null) {
            builder.appendWithinLine(this.positional.toShortArgs(colors));
        }
        builder.indent(0).newLine();
        if (this.summary != null) {
            builder.newLine().appendText(this.summary, 0);
        }
        builder.indent(4);
        builder.newLine();
        for (Arg arg : this.args) {
            this.writeArgHelp(colors, builder, arg);
        }
        if (this.positional != null) {
            this.writeArgHelp(colors, builder, this.positional);
        }
        if (!StringUtils.isEmpty((CharSequence)this.documentation)) {
            builder.indent(0).newLine().appendText(this.documentation, 0);
        }
        printer.println(builder.toString());
    }

    private void writeArgHelp(ColorFormatter colors, LineWrapper builder, Arg arg) {
        if (arg.longName != null) {
            builder.appendWithinLine(colors.style(arg.longName, Style.YELLOW));
            if (arg.shortName != null) {
                builder.appendWithinLine(", ");
            }
        }
        if (arg.shortName != null) {
            builder.appendWithinLine(colors.style(arg.shortName, Style.YELLOW));
        }
        if (arg.exampleValue != null) {
            builder.space().appendWithinLine(arg.exampleValue);
        }
        builder.indent(8);
        builder.newLine();
        builder.appendText(arg.description, 4);
    }

    private static final class LineWrapper {
        private final StringBuilder builder = new StringBuilder();
        private final int maxLength;
        private int column = 0;
        private int indent = 0;

        private LineWrapper(int maxLength) {
            this.maxLength = maxLength;
        }

        public String toString() {
            return this.builder.toString();
        }

        LineWrapper indent(int indent) {
            this.indent = indent;
            return this;
        }

        LineWrapper space() {
            if (this.column >= 0) {
                this.builder.append(' ');
            }
            ++this.column;
            return this;
        }

        LineWrapper appendWithinLine(String text) {
            if (this.column + text.length() > this.maxLength) {
                this.newLine();
            }
            this.builder.append(text);
            this.column += text.length();
            return this;
        }

        LineWrapper appendText(String text, int indentAfter) {
            StringTokenizer tokenizer = new StringTokenizer(text, " \t\n\r\f", true);
            boolean pendingCarriage = false;
            while (tokenizer.hasMoreElements()) {
                String next = tokenizer.nextToken();
                if (next.equals("\n")) {
                    pendingCarriage = false;
                    this.newLine();
                    continue;
                }
                if (pendingCarriage) {
                    this.newLine();
                    pendingCarriage = false;
                }
                if (next.equals("\r")) {
                    pendingCarriage = true;
                    continue;
                }
                this.appendWithinLine(next);
            }
            if (pendingCarriage) {
                this.newLine();
            }
            this.indent(indentAfter);
            this.newLine();
            return this;
        }

        LineWrapper newLine() {
            this.builder.append(System.lineSeparator());
            for (int i = 0; i < this.indent; ++i) {
                this.builder.append(' ');
            }
            this.column = this.indent;
            return this;
        }
    }

    private static final class Arg {
        final String longName;
        final String shortName;
        final String exampleValue;
        final String description;

        private Arg(String longName, String shortName, String exampleValue, String description) {
            this.longName = longName;
            this.shortName = shortName;
            this.exampleValue = exampleValue;
            this.description = description;
        }

        static Arg option(String longName, String shortName, String description) {
            return new Arg(longName, shortName, null, description);
        }

        static Arg parameter(String longName, String shortName, String exampleValue, String description) {
            return new Arg(longName, shortName, exampleValue, description);
        }

        static Arg positional(String name, String description) {
            return new Arg(name, null, null, description);
        }

        String toShortArgs(ColorFormatter colors) {
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            if (this.longName != null) {
                builder.append(colors.style(this.longName, Style.YELLOW));
                if (this.shortName != null) {
                    builder.append(" | ");
                }
            }
            if (this.shortName != null) {
                builder.append(colors.style(this.shortName, Style.YELLOW));
            }
            if (this.exampleValue != null) {
                builder.append(' ').append(this.exampleValue);
            }
            builder.append(']');
            return builder.toString();
        }
    }
}

