/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.cli.Style;

final class LoggingUtil {
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final List<Runnable> RESTORE_FUNCTIONS = new ArrayList<Runnable>();

    private LoggingUtil() {
    }

    static void configureLogging(StandardOptions options, ColorFormatter colors, CliPrinter printer) {
        if (!RESTORE_FUNCTIONS.isEmpty()) {
            return;
        }
        Level level = options.logging();
        Logger rootLogger = Logger.getLogger("");
        Level previousRootLevel = rootLogger.getLevel();
        RESTORE_FUNCTIONS.add(() -> rootLogger.setLevel(previousRootLevel));
        rootLogger.setLevel(level);
        for (Handler h : rootLogger.getHandlers()) {
            if (h instanceof ConsoleHandler) {
                rootLogger.removeHandler(h);
                RESTORE_FUNCTIONS.add(() -> rootLogger.addHandler(h));
                continue;
            }
            if (h.getLevel() == level) continue;
            Level currentLevel = h.getLevel();
            RESTORE_FUNCTIONS.add(() -> h.setLevel(currentLevel));
            h.setLevel(level);
        }
        LoggingUtil.addCliHandler(options.debug(), level, rootLogger, colors, printer);
    }

    static void restoreLogging() {
        for (Runnable runnable : RESTORE_FUNCTIONS) {
            runnable.run();
        }
        RESTORE_FUNCTIONS.clear();
    }

    private static void addCliHandler(boolean debug, Level level, Logger rootLogger, ColorFormatter colors, CliPrinter printer) {
        if (level != Level.OFF) {
            CliLogHandler handler = debug ? new CliLogHandler(new DebugFormatter(), colors, printer) : new CliLogHandler(new BasicFormatter(), colors, printer);
            handler.setLevel(level);
            rootLogger.addHandler(handler);
            RESTORE_FUNCTIONS.add(() -> rootLogger.removeHandler(handler));
        }
    }

    private static final class CliLogHandler
    extends Handler {
        private final Formatter formatter;
        private final ColorFormatter colors;
        private final CliPrinter printer;

        CliLogHandler(Formatter formatter, ColorFormatter colors, CliPrinter printer) {
            this.formatter = formatter;
            this.colors = colors;
            this.printer = printer;
        }

        @Override
        public void publish(LogRecord record) {
            if (this.isLoggable(record)) {
                String formatted = this.formatter.format(record);
                if (record.getLevel().equals(Level.SEVERE)) {
                    this.colors.println(this.printer, formatted, Style.RED);
                } else if (record.getLevel().equals(Level.WARNING)) {
                    this.colors.println(this.printer, formatted, Style.YELLOW);
                } else {
                    this.printer.println(formatted);
                }
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    private static final class DebugFormatter
    extends SimpleFormatter {
        private DebugFormatter() {
        }

        @Override
        public synchronized String format(LogRecord r) {
            StringBuilder result = new StringBuilder();
            result.append(FORMAT.format(new Date(r.getMillis())));
            result.append(' ');
            result.append('[');
            result.append(Thread.currentThread().getName());
            result.append(']');
            result.append(' ');
            result.append(r.getLevel().getLocalizedName());
            result.append(' ');
            result.append(r.getLoggerName());
            result.append(' ');
            result.append('-');
            result.append(' ');
            result.append(r.getMessage());
            return result.toString();
        }
    }

    private static final class BasicFormatter
    extends SimpleFormatter {
        private BasicFormatter() {
        }

        @Override
        public synchronized String format(LogRecord r) {
            return '[' + r.getLevel().getLocalizedName() + "] " + r.getMessage();
        }
    }
}

