/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class Arguments {
    private final String[] args;
    private final Map<Class<? extends ArgumentReceiver>, ArgumentReceiver> receivers = new LinkedHashMap<Class<? extends ArgumentReceiver>, ArgumentReceiver>();
    private final List<BiConsumer<Arguments, List<String>>> subscribers = new ArrayList<BiConsumer<Arguments, List<String>>>();
    private boolean inPositional = false;
    private int position = 0;

    public Arguments(String[] args) {
        this.args = args;
    }

    public <T extends ArgumentReceiver> void addReceiver(T receiver) {
        this.receivers.put(receiver.getClass(), receiver);
    }

    public <T extends ArgumentReceiver> T getReceiver(Class<T> type) {
        return (T)Objects.requireNonNull(this.receivers.get(type));
    }

    public Iterable<ArgumentReceiver> getReceivers() {
        return this.receivers.values();
    }

    public void onComplete(BiConsumer<Arguments, List<String>> consumer) {
        this.subscribers.add(consumer);
    }

    public boolean hasNext() {
        return this.position < this.args.length;
    }

    public String peek() {
        String peek;
        String string = peek = this.hasNext() ? this.args[this.position] : null;
        if (peek != null && !this.inPositional) {
            if (peek.equals("--")) {
                this.inPositional = true;
                ++this.position;
                return this.peek();
            }
            for (ArgumentReceiver interceptor : this.receivers.values()) {
                if (interceptor.testOption(peek)) {
                    ++this.position;
                    return this.peek();
                }
                Consumer<String> optionConsumer = interceptor.testParameter(peek);
                if (optionConsumer == null) continue;
                ++this.position;
                optionConsumer.accept(this.shiftFor(peek));
                return this.peek();
            }
        }
        return peek;
    }

    public String shift() {
        String peek = this.peek();
        if (peek != null) {
            ++this.position;
        }
        return peek;
    }

    public String shiftFor(String parameter) {
        if (!this.hasNext()) {
            throw new CliError("Expected argument for '" + parameter + "'");
        }
        String next = this.args[this.position];
        ++this.position;
        return next;
    }

    public List<String> finishParsing() {
        ArrayList<String> positional = new ArrayList<String>();
        while (this.hasNext()) {
            String next = this.shift();
            if (next == null) continue;
            if (!this.inPositional && next.startsWith("-")) {
                throw new CliError("Unexpected CLI argument: " + next);
            }
            this.inPositional = true;
            positional.add(next);
        }
        this.invokeSubscribers(positional);
        return positional;
    }

    private void invokeSubscribers(List<String> positional) {
        for (BiConsumer<Arguments, List<String>> subscriber : this.subscribers) {
            subscriber.accept(this, positional);
        }
    }
}

