/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.Cli;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.Colors;
import software.amazon.smithy.cli.commands.Validator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.validation.ContextualValidationEventFormatter;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;

final class CommandUtils {
    private static final Logger LOGGER = Logger.getLogger(CommandUtils.class.getName());

    private CommandUtils() {
    }

    static Model buildModel(Arguments arguments, ClassLoader classLoader, Set<Validator.Feature> features) {
        List<String> models = arguments.positionalArguments();
        ModelAssembler assembler = CommandUtils.createModelAssembler(classLoader);
        ContextualValidationEventFormatter formatter = new ContextualValidationEventFormatter();
        boolean stdout = features.contains((Object)Validator.Feature.STDOUT);
        boolean quiet = features.contains((Object)Validator.Feature.QUIET);
        Consumer<String> writer = stdout ? Cli.getStdout() : Cli.getStderr();
        Severity minSeverity = arguments.has("--severity") ? CommandUtils.parseSeverity(arguments.parameter("--severity")) : Severity.NOTE;
        assembler.validationEventListener(event -> {
            if (event.getSeverity().ordinal() >= minSeverity.ordinal()) {
                if (event.getSeverity() == Severity.WARNING && !quiet) {
                    Colors.YELLOW.write(writer, formatter.format(event) + System.lineSeparator());
                } else if (event.getSeverity() == Severity.DANGER || event.getSeverity() == Severity.ERROR) {
                    Colors.RED.write(writer, formatter.format(event) + System.lineSeparator());
                } else if (!quiet) {
                    writer.accept(formatter.format(event) + System.lineSeparator());
                }
            }
        });
        CommandUtils.handleModelDiscovery(arguments, assembler, classLoader);
        CommandUtils.handleUnknownTraitsOption(arguments, assembler);
        models.forEach(arg_0 -> ((ModelAssembler)assembler).addImport(arg_0));
        ValidatedResult result = assembler.assemble();
        Validator.validate((ValidatedResult<Model>)result, features);
        return (Model)result.getResult().orElseThrow(() -> new RuntimeException("Expected Validator to throw"));
    }

    static Severity parseSeverity(String str) {
        return (Severity)Severity.fromString((String)str).orElseThrow(() -> new IllegalArgumentException("Invalid severity: " + str + ". Expected one of: " + Arrays.toString(Severity.values())));
    }

    static ModelAssembler createModelAssembler(ClassLoader classLoader) {
        return Model.assembler((ClassLoader)classLoader).putProperty("assembler.disableJarCache", (Object)true);
    }

    private static void handleUnknownTraitsOption(Arguments arguments, ModelAssembler assembler) {
        if (arguments.has("--allow-unknown-traits")) {
            LOGGER.fine("Ignoring unknown traits");
            assembler.putProperty("assembler.allowUnknownTraits", (Object)true);
        }
    }

    private static void handleModelDiscovery(Arguments arguments, ModelAssembler assembler, ClassLoader baseLoader) {
        if (arguments.has("--discover-classpath")) {
            CommandUtils.discoverModelsWithClasspath(arguments, assembler);
        } else if (arguments.has("--discover")) {
            assembler.discoverModels(baseLoader);
        }
    }

    private static void discoverModelsWithClasspath(Arguments arguments, ModelAssembler assembler) {
        String rawClasspath = arguments.parameter("--discover-classpath");
        LOGGER.finer("Discovering models with classpath: " + rawClasspath);
        String[] classpath = rawClasspath.split(System.getProperty("path.separator"));
        URL[] urls = new URL[classpath.length];
        for (int i = 0; i < classpath.length; ++i) {
            try {
                urls[i] = Paths.get(classpath[i], new String[0]).toUri().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new CliError("Error parsing model discovery URL: " + classpath[i]);
            }
        }
        AccessController.doPrivileged(() -> {
            URLClassLoader urlClassLoader = new URLClassLoader(urls);
            assembler.discoverModels((ClassLoader)urlClassLoader);
            return null;
        });
    }
}

