/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import software.amazon.smithy.cli.Cli;

final class LoggingUtil {
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");

    private LoggingUtil() {
    }

    static void configureLogging(boolean debug, Level level) {
        Logger rootLogger = Logger.getLogger("");
        LoggingUtil.removeConsoleHandler(rootLogger);
        LoggingUtil.addCliHandler(debug, level, rootLogger);
    }

    private static void addCliHandler(boolean debug, Level level, Logger rootLogger) {
        if (level != Level.OFF) {
            CliLogHandler handler = debug ? new CliLogHandler(new DebugFormatter()) : new CliLogHandler(new BasicFormatter());
            handler.setLevel(level);
            rootLogger.addHandler(handler);
        }
        rootLogger.setLevel(level);
        for (Handler h : rootLogger.getHandlers()) {
            h.setLevel(level);
        }
    }

    private static void removeConsoleHandler(Logger rootLogger) {
        for (Handler handler : rootLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            rootLogger.removeHandler(handler);
        }
    }

    private static final class CliLogHandler
    extends Handler {
        private final Formatter formatter;

        CliLogHandler(Formatter formatter) {
            this.formatter = formatter;
        }

        @Override
        public void publish(LogRecord record) {
            if (this.isLoggable(record)) {
                Cli.stderr(this.formatter.format(record));
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    private static final class DebugFormatter
    extends SimpleFormatter {
        private DebugFormatter() {
        }

        @Override
        public synchronized String format(LogRecord r) {
            return FORMAT.format(new Date(r.getMillis())) + " [" + Thread.currentThread().getName() + "] " + r.getLevel().getLocalizedName() + " " + r.getLoggerName() + " - " + r.getMessage();
        }
    }

    private static final class BasicFormatter
    extends SimpleFormatter {
        private BasicFormatter() {
        }

        @Override
        public synchronized String format(LogRecord r) {
            return FORMAT.format(new Date(r.getMillis())) + " " + r.getLevel().getLocalizedName() + " - " + r.getMessage();
        }
    }
}

