/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.Set;
import java.util.function.Consumer;
import software.amazon.smithy.cli.Cli;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;

final class Validator {
    private Validator() {
    }

    static void validate(ValidatedResult<Model> result, Set<Feature> features) {
        boolean quiet = features.contains((Object)Feature.QUIET);
        boolean stdout = features.contains((Object)Feature.STDOUT);
        Consumer<String> writer = stdout ? Cli.getStdout() : Cli.getStderr();
        long errors = result.getValidationEvents(Severity.ERROR).size();
        long dangers = result.getValidationEvents(Severity.DANGER).size();
        if (!quiet) {
            String line = String.format("Validation result: %s ERROR(s), %d DANGER(s), %d WARNING(s), %d NOTE(s)", errors, dangers, result.getValidationEvents(Severity.WARNING).size(), result.getValidationEvents(Severity.NOTE).size());
            writer.accept(line);
            result.getResult().ifPresent(model -> writer.accept(String.format("Validated %d shapes in model", model.shapes().count())));
        }
        if (!result.getResult().isPresent() || errors + dangers > 0L) {
            throw new CliError(String.format("The model is invalid: %s ERROR(s), %d DANGER(s)", errors, dangers));
        }
    }

    static enum Feature {
        QUIET,
        STDOUT;

    }
}

