/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.List;
import java.util.Set;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.BackwardCompatHelper;
import software.amazon.smithy.model.Model;

public final class Apply
extends BackwardCompatHelper<Config> {
    private final ApplyCallback applyCallback;

    public Apply(ApplyCallback applyCallback) {
        this.applyCallback = applyCallback;
    }

    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    public String getName() {
        return "apply";
    }

    @Override
    String getBackwardCompatibleNameMapping() {
        return "projections";
    }

    @Override
    protected Model transformWithConfig(TransformContext context, Config config) {
        Model current = context.getModel();
        Set<String> visited = context.getVisited();
        for (String projection : config.getProjections()) {
            current = this.applyCallback.apply(current, projection, visited);
        }
        return current;
    }

    @FunctionalInterface
    public static interface ApplyCallback {
        public Model apply(Model var1, String var2, Set<String> var3);
    }

    public static final class Config {
        private List<String> projections;

        public List<String> getProjections() {
            return this.projections;
        }

        public void setProjections(List<String> projections) {
            this.projections = projections;
        }
    }
}

