/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.model;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.build.model.ConfigLoader;
import software.amazon.smithy.build.model.ProjectionConfig;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class SmithyBuildConfig
implements ToSmithyBuilder<SmithyBuildConfig> {
    private static final Set<String> BUILTIN_PLUGINS = SetUtils.of((Object[])new String[]{"build-info", "model", "sources"});
    private final String version;
    private final List<String> imports;
    private final String outputDirectory;
    private final Map<String, ProjectionConfig> projections;
    private final Map<String, ObjectNode> plugins;

    private SmithyBuildConfig(Builder builder) {
        SmithyBuilder.requiredState((String)"version", (Object)builder.version);
        this.version = builder.version;
        this.outputDirectory = builder.outputDirectory;
        this.imports = ListUtils.copyOf((Collection)builder.imports);
        this.projections = MapUtils.copyOf((Map)builder.projections);
        this.plugins = new HashMap<String, ObjectNode>(builder.plugins);
        for (String builtin : BUILTIN_PLUGINS) {
            this.plugins.put(builtin, Node.objectNode());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SmithyBuildConfig load(Path file) {
        return SmithyBuildConfig.builder().load(file).build();
    }

    public Builder toBuilder() {
        return SmithyBuildConfig.builder().version(this.version).outputDirectory(this.outputDirectory).imports(this.imports).projections(this.projections).plugins(this.plugins);
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public Optional<String> getOutputDirectory() {
        return Optional.ofNullable(this.outputDirectory);
    }

    public Map<String, ProjectionConfig> getProjections() {
        return Collections.unmodifiableMap(this.projections);
    }

    public Map<String, ObjectNode> getPlugins() {
        return Collections.unmodifiableMap(this.plugins);
    }

    public static final class Builder
    implements SmithyBuilder<SmithyBuildConfig> {
        private final List<String> imports = new ArrayList<String>();
        private final Map<String, ProjectionConfig> projections = new LinkedHashMap<String, ProjectionConfig>();
        private final Map<String, ObjectNode> plugins = new LinkedHashMap<String, ObjectNode>();
        private String version;
        private String outputDirectory;

        Builder() {
        }

        public SmithyBuildConfig build() {
            return new SmithyBuildConfig(this);
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder load(Path config) {
            return this.merge(ConfigLoader.load(config));
        }

        public Builder merge(SmithyBuildConfig config) {
            config.getOutputDirectory().ifPresent(this::outputDirectory);
            this.version(config.getVersion());
            this.imports.addAll(config.getImports());
            this.projections.putAll(config.getProjections());
            this.plugins.putAll(config.getPlugins());
            return this;
        }

        public Builder outputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        public Builder imports(Collection<String> imports) {
            this.imports.clear();
            this.imports.addAll(imports);
            return this;
        }

        public Builder projections(Map<String, ProjectionConfig> projections) {
            this.projections.clear();
            this.projections.putAll(projections);
            return this;
        }

        public Builder plugins(Map<String, ObjectNode> plugins) {
            this.plugins.clear();
            this.plugins.putAll(plugins);
            return this;
        }
    }
}

