/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import software.amazon.smithy.build.ProjectionTransformer;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.utils.ListUtils;

public abstract class ConfigurableProjectionTransformer<T>
implements ProjectionTransformer {
    public abstract Class<T> getConfigType();

    @Override
    public Model transform(TransformContext context) {
        NodeMapper mapper = new NodeMapper();
        Object config = mapper.deserialize((Node)context.getSettings(), this.getConfigType());
        return this.transformWithConfig(context, config);
    }

    @Override
    public List<String> getAdditionalProjections(TransformContext context) {
        return this.getAdditionalProjectionsFunction().map(fn -> {
            NodeMapper mapper = new NodeMapper();
            Object config = mapper.deserialize((Node)context.getSettings(), this.getConfigType());
            return (List)fn.apply(context, config);
        }).orElseGet(ListUtils::of);
    }

    protected abstract Model transformWithConfig(TransformContext var1, T var2);

    protected Optional<BiFunction<TransformContext, T, List<String>>> getAdditionalProjectionsFunction() {
        return Optional.empty();
    }
}

