/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.plugins;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.build.SmithyBuildPlugin;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.ModelSerializer;
import software.amazon.smithy.utils.IoUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

public final class RunPlugin
implements SmithyBuildPlugin {
    private static final Logger LOGGER = Logger.getLogger(RunPlugin.class.getName());
    private final Path root = Paths.get(".", new String[0]).toAbsolutePath().normalize();

    @Override
    public String getName() {
        return "run";
    }

    @Override
    public boolean requiresValidModel() {
        return true;
    }

    @Override
    public void execute(PluginContext context) {
        NodeMapper mapper = new NodeMapper();
        mapper.setWhenMissingSetter(NodeMapper.WhenMissing.FAIL);
        Settings settings = (Settings)mapper.deserializeInto((Node)context.getSettings(), (Object)new Settings());
        String artifactName = context.getArtifactName().orElseThrow(() -> new SmithyBuildException("The run plugin requires an artifact name"));
        if (settings.command().isEmpty()) {
            throw new SmithyBuildException("Missing required command setting");
        }
        this.ensureDirectoryExists(context);
        this.useProjectRelativeCommandIfPossible(settings.command());
        this.runCommand(artifactName, context, settings);
    }

    private void ensureDirectoryExists(PluginContext context) {
        try {
            Files.createDirectories(context.getFileManifest().getBaseDir(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SmithyBuildException("Error creating plugin directory for " + this.getName(), e);
        }
    }

    private void runCommand(String artifactName, PluginContext context, Settings settings) {
        int result;
        Path baseDir = context.getFileManifest().getBaseDir();
        List<String> command = settings.command();
        Map<String, String> env = this.prepareEnvironment(context, settings);
        InputStream inputStream = this.serializeModel(settings, context.getModel());
        StringBuilder appendable = new StringBuilder();
        LOGGER.fine(() -> "Running command for artifact " + context.getArtifactName().orElse(this.getName()) + ": " + command);
        try {
            result = IoUtils.runCommand(command, (Path)baseDir, (InputStream)inputStream, (Appendable)appendable, env);
        }
        catch (RuntimeException e) {
            throw new SmithyBuildException("Error running process `" + String.join((CharSequence)" ", command) + "` for '" + artifactName + "': " + e.getMessage(), e);
        }
        if (result != 0) {
            throw new SmithyBuildException(("Error exit code " + result + " returned from: `" + String.join((CharSequence)" ", command) + "`: " + appendable).trim());
        }
        LOGGER.fine(() -> (String)command.get(0) + " output: " + appendable);
    }

    private void useProjectRelativeCommandIfPossible(List<String> command) {
        Path resolvedRelativeCommand = this.root.resolve(command.get(0));
        if (Files.isExecutable(resolvedRelativeCommand)) {
            String absolute = resolvedRelativeCommand.toAbsolutePath().toString();
            LOGGER.fine(() -> "Found command " + (String)command.get(0) + " relative to current directory: " + absolute);
            command.set(0, absolute);
        }
    }

    private Map<String, String> prepareEnvironment(PluginContext context, Settings settings) {
        HashMap<String, String> env = new HashMap<String, String>(settings.env);
        env.putIfAbsent("SMITHY_ROOT_DIR", this.root.toString());
        env.putIfAbsent("SMITHY_PLUGIN_DIR", context.getFileManifest().getBaseDir().toString());
        env.putIfAbsent("SMITHY_PROJECTION_NAME", context.getProjectionName());
        env.putIfAbsent("SMITHY_ARTIFACT_NAME", context.getArtifactName().orElse(""));
        env.putIfAbsent("SMITHY_INCLUDES_PRELUDE", String.valueOf(settings.sendPrelude()));
        return env;
    }

    private InputStream serializeModel(Settings settings, Model model) {
        ModelSerializer serializer = ModelSerializer.builder().includePrelude(settings.sendPrelude()).build();
        String jsonModel = Node.printJson((Node)serializer.serialize(model));
        return new ByteArrayInputStream(jsonModel.getBytes(StandardCharsets.UTF_8));
    }

    @SmithyInternalApi
    public static final class Settings {
        private List<String> command = Collections.emptyList();
        private Map<String, String> env = Collections.emptyMap();
        private boolean sendPrelude;

        public List<String> command() {
            return this.command;
        }

        public void command(List<String> command) {
            this.command = command;
        }

        public boolean sendPrelude() {
            return this.sendPrelude;
        }

        public void sendPrelude(boolean sendPrelude) {
            this.sendPrelude = sendPrelude;
        }

        public Map<String, String> env() {
            return this.env;
        }

        public void env(Map<String, String> env) {
            this.env = env;
        }
    }
}

