/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.ConfigurableProjectionTransformer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.SuppressTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.suppressions.Suppression;

public final class FilterSuppressions
extends ConfigurableProjectionTransformer<Config> {
    private static final Logger LOGGER = Logger.getLogger(FilterSuppressions.class.getName());

    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    public String getName() {
        return "filterSuppressions";
    }

    @Override
    protected Model transformWithConfig(TransformContext context, Config config) {
        if (!config.getEventIdAllowList().isEmpty() && !config.getEventIdDenyList().isEmpty()) {
            throw new SmithyBuildException(this.getName() + ": cannot set both eventIdAllowList values and eventIdDenyList values at the same time");
        }
        if (!config.getNamespaceAllowList().isEmpty() && !config.getNamespaceDenyList().isEmpty()) {
            throw new SmithyBuildException(this.getName() + ": cannot set both namespaceAllowList values and namespaceDenyList values at the same time");
        }
        Model model = context.getModel();
        Set<String> removedValidators = this.getRemovedValidators(context, config);
        List<ValidationEvent> suppressedEvents = context.getOriginalModelValidationEvents().stream().filter(event -> event.getSeverity() == Severity.SUPPRESSED).filter(event -> !removedValidators.contains(event.getId())).collect(Collectors.toList());
        model = this.filterSuppressionTraits(model, config, suppressedEvents, context.getTransformer());
        model = this.filterMetadata(model, config, suppressedEvents, removedValidators);
        return model;
    }

    private Set<String> getRemovedValidators(TransformContext context, Config config) {
        Set<String> updatedValidators;
        if (!context.getOriginalModel().isPresent()) {
            return Collections.emptySet();
        }
        Set<String> originalValidators = this.getValidatorNames(context.getOriginalModel().get());
        if (originalValidators.equals(updatedValidators = this.getValidatorNames(context.getModel()))) {
            return Collections.emptySet();
        }
        originalValidators.removeAll(updatedValidators);
        if (config.getRemoveUnused()) {
            LOGGER.info(() -> "Detected the removal of the following validators: " + originalValidators + ". Suppressions that refer to these validators will be removed.");
        }
        return originalValidators;
    }

    private Set<String> getValidatorNames(Model model) {
        ArrayNode validators = ((Node)model.getMetadata().getOrDefault("validators", Node.arrayNode())).expectArrayNode();
        HashSet<String> metadataSuppressions = new HashSet<String>();
        for (Node validator : validators) {
            ObjectNode validatorObject = validator.expectObjectNode();
            String id = validatorObject.getStringMember("id").orElseGet(() -> validatorObject.expectStringMember("name")).getValue();
            metadataSuppressions.add(id);
        }
        return metadataSuppressions;
    }

    private Model filterSuppressionTraits(Model model, Config config, List<ValidationEvent> suppressedEvents, ModelTransformer transformer) {
        ArrayList<Shape> replacementShapes = new ArrayList<Shape>();
        for (Shape shape : model.getShapesWithTrait(SuppressTrait.class)) {
            SuppressTrait trait = (SuppressTrait)shape.expectTrait(SuppressTrait.class);
            ArrayList<String> allowed = new ArrayList<String>(trait.getValues());
            allowed.removeIf(value -> !this.isAllowed((String)value, (Collection<String>)config.getEventIdAllowList(), (Collection<String>)config.getEventIdDenyList()));
            if (config.getRemoveUnused()) {
                Set matchedEvents = suppressedEvents.stream().filter(event -> Objects.equals(shape.getId(), event.getShapeId().orElse(null))).collect(Collectors.toSet());
                allowed.removeIf(value -> matchedEvents.stream().noneMatch(event -> event.containsId(value)));
            }
            if (allowed.isEmpty()) {
                replacementShapes.add((Shape)Shape.shapeToBuilder((Shape)shape).removeTrait(SuppressTrait.ID).build());
                continue;
            }
            if (allowed.equals(trait.getValues())) continue;
            trait = ((SuppressTrait.Builder)trait.toBuilder().values(allowed)).build();
            replacementShapes.add((Shape)Shape.shapeToBuilder((Shape)shape).addTrait((Trait)trait).build());
        }
        return transformer.replaceShapes(model, replacementShapes);
    }

    private Model filterMetadata(Model model, Config config, List<ValidationEvent> suppressedEvents, Set<String> removedValidators) {
        ArrayNode suppressionsNode = ((Node)model.getMetadata().getOrDefault("suppressions", Node.arrayNode())).expectArrayNode();
        ArrayList<ObjectNode> updatedMetadataSuppressions = new ArrayList<ObjectNode>();
        block0: for (Node suppressionNode : suppressionsNode) {
            ObjectNode object = suppressionNode.expectObjectNode();
            String id = object.getStringMemberOrDefault("id", "");
            String namespace = object.getStringMemberOrDefault("namespace", "");
            if (config.getRemoveReasons()) {
                object = object.withoutMember("reason");
            }
            if (!this.isAllowed(id, config.getEventIdAllowList(), config.getEventIdDenyList()) || !this.isAllowed(namespace, config.getNamespaceAllowList(), config.getNamespaceDenyList())) continue;
            if (!config.getRemoveUnused()) {
                updatedMetadataSuppressions.add(object);
                continue;
            }
            Suppression suppression = Suppression.fromMetadata((Node)object);
            for (ValidationEvent event : suppressedEvents) {
                if (removedValidators.contains(event.getId()) || !suppression.test(event)) continue;
                updatedMetadataSuppressions.add(object);
                continue block0;
            }
        }
        ArrayNode updatedMetadataSuppressionsNode = Node.fromNodes(updatedMetadataSuppressions);
        if (suppressionsNode.equals((Object)updatedMetadataSuppressionsNode)) {
            return model;
        }
        Model.Builder builder = model.toBuilder();
        builder.removeMetadataProperty("suppressions");
        if (!updatedMetadataSuppressions.isEmpty()) {
            builder.putMetadataProperty("suppressions", (Node)updatedMetadataSuppressionsNode);
        }
        return builder.build();
    }

    private boolean isAllowed(String value, Collection<String> allowList, Collection<String> denyList) {
        return !(!allowList.isEmpty() && !allowList.contains(value) || !denyList.isEmpty() && denyList.contains(value));
    }

    public static final class Config {
        private boolean removeUnused = false;
        private boolean removeReasons = false;
        private Set<String> eventIdAllowList = Collections.emptySet();
        private Set<String> eventIdDenyList = Collections.emptySet();
        private Set<String> namespaceAllowList = Collections.emptySet();
        private Set<String> namespaceDenyList = Collections.emptySet();

        public boolean getRemoveUnused() {
            return this.removeUnused;
        }

        public void setRemoveUnused(boolean removeUnused) {
            this.removeUnused = removeUnused;
        }

        public boolean getRemoveReasons() {
            return this.removeReasons;
        }

        public void setRemoveReasons(boolean removeReasons) {
            this.removeReasons = removeReasons;
        }

        public Set<String> getEventIdAllowList() {
            return this.eventIdAllowList;
        }

        public void setEventIdAllowList(Set<String> eventIdAllowList) {
            this.eventIdAllowList = eventIdAllowList;
        }

        public Set<String> getEventIdDenyList() {
            return this.eventIdDenyList;
        }

        public void setEventIdDenyList(Set<String> eventIdDenyList) {
            this.eventIdDenyList = eventIdDenyList;
        }

        public Set<String> getNamespaceAllowList() {
            return this.namespaceAllowList;
        }

        public void setNamespaceAllowList(Set<String> namespaceAllowList) {
            this.namespaceAllowList = namespaceAllowList;
        }

        public Set<String> getNamespaceDenyList() {
            return this.namespaceDenyList;
        }

        public void setNamespaceDenyList(Set<String> namespaceDenyList) {
            this.namespaceDenyList = namespaceDenyList;
        }
    }
}

