/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build;

import java.util.Objects;

final class PluginId {
    private final String pluginName;
    private final String artifactName;

    PluginId(String pluginName, String artifactName) {
        this.pluginName = Objects.requireNonNull(pluginName);
        this.artifactName = artifactName;
    }

    static PluginId from(String identifier) {
        String pluginName = identifier;
        String artifactName = null;
        int separatorPosition = identifier.indexOf("::");
        if (separatorPosition > -1) {
            pluginName = identifier.substring(0, separatorPosition);
            artifactName = identifier.substring(separatorPosition + 2);
        }
        return new PluginId(pluginName, artifactName);
    }

    String getPluginName() {
        return this.pluginName;
    }

    String getArtifactName() {
        return this.hasArtifactName() ? this.artifactName : this.pluginName;
    }

    boolean hasArtifactName() {
        return this.artifactName != null;
    }

    public String toString() {
        if (!this.hasArtifactName()) {
            return this.pluginName;
        }
        return this.pluginName + "::" + this.artifactName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginId)) {
            return false;
        }
        PluginId pluginId = (PluginId)o;
        return this.pluginName.equals(pluginId.pluginName) && Objects.equals(this.artifactName, pluginId.artifactName);
    }

    public int hashCode() {
        return Objects.hash(this.pluginName, this.artifactName);
    }
}

