/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.ConfigurableProjectionTransformer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;

public final class ChangeTypes
extends ConfigurableProjectionTransformer<Config> {
    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    public String getName() {
        return "changeTypes";
    }

    @Override
    protected Model transformWithConfig(TransformContext context, Config config) {
        if (config.getShapeTypes().isEmpty()) {
            throw new SmithyBuildException(this.getName() + ": shapeTypes must not be empty");
        }
        return context.getTransformer().changeShapeType(context.getModel(), config.getShapeTypes());
    }

    public static final class Config {
        private final Map<ShapeId, ShapeType> shapeTypes = new LinkedHashMap<ShapeId, ShapeType>();

        public void setShapeTypes(Map<ShapeId, ShapeType> shapeTypes) {
            this.shapeTypes.clear();
            this.shapeTypes.putAll(shapeTypes);
        }

        public Map<ShapeId, ShapeType> getShapeTypes() {
            return this.shapeTypes;
        }
    }
}

