/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build;

import java.util.HashMap;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.model.Model;

public interface ProjectionTransformer {
    public String getName();

    public Model transform(TransformContext var1);

    public static Function<String, Optional<ProjectionTransformer>> createServiceFactory() {
        return ProjectionTransformer.createServiceFactory(ServiceLoader.load(ProjectionTransformer.class));
    }

    public static Function<String, Optional<ProjectionTransformer>> createServiceFactory(Iterable<ProjectionTransformer> transformers) {
        HashMap<String, ProjectionTransformer> map = new HashMap<String, ProjectionTransformer>();
        for (ProjectionTransformer transformer : transformers) {
            map.put(transformer.getName(), transformer);
        }
        return name -> Optional.ofNullable(map.get(name));
    }

    public static Function<String, Optional<ProjectionTransformer>> createServiceFactory(ClassLoader classLoader) {
        return ProjectionTransformer.createServiceFactory(ServiceLoader.load(ProjectionTransformer.class, classLoader));
    }
}

