/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;

public final class TransformConfig
implements ToNode {
    private final String name;
    private final List<String> args;

    private TransformConfig(Builder builder) {
        this.name = (String)SmithyBuilder.requiredState((String)"name", (Object)builder.name);
        this.args = ListUtils.copyOf((Collection)builder.args);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public Node toNode() {
        return Node.objectNodeBuilder().withMember("name", (ToNode)Node.from((String)this.getName())).withMember("args", (ToNode)Node.fromStrings(this.args)).build();
    }

    public static final class Builder
    implements SmithyBuilder<TransformConfig> {
        private String name;
        private List<String> args = Collections.emptyList();

        private Builder() {
        }

        public TransformConfig build() {
            return new TransformConfig(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder args(List<String> args) {
            this.args = args;
            return this;
        }
    }
}

