/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import software.amazon.smithy.build.ProjectionTransformer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.ProtocolsTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.transform.ModelTransformer;

public final class IncludeProtocols
implements ProjectionTransformer {
    @Override
    public String getName() {
        return "includeProtocols";
    }

    @Override
    public BiFunction<ModelTransformer, Model, Model> createTransformer(List<String> arguments) {
        HashSet<String> includeNames = new HashSet<String>(arguments);
        return (transformer, model) -> transformer.mapShapes(model, shape -> shape.getTrait(ProtocolsTrait.class).map(protocols -> {
            Set<String> names = IncludeProtocols.getSchemeNameIntersection(protocols, includeNames);
            return names.size() == protocols.getProtocols().size() ? shape : IncludeProtocols.updateTrait(shape, protocols, includeNames);
        }).orElse((Shape)shape));
    }

    private static Set<String> getSchemeNameIntersection(ProtocolsTrait protocols, Set<String> includeNames) {
        HashSet<String> names = new HashSet<String>(protocols.getProtocolNames());
        names.retainAll(includeNames);
        return names;
    }

    private static Shape updateTrait(Shape shape, ProtocolsTrait trait, Set<String> names) {
        ProtocolsTrait.Builder builder = ProtocolsTrait.builder();
        builder.clearProtocols();
        trait.getProtocols().stream().filter(protocol -> names.contains(protocol.getName())).forEach(arg_0 -> ((ProtocolsTrait.Builder)builder).addProtocol(arg_0));
        return (Shape)Shape.shapeToBuilder((Shape)shape).addTrait((Trait)builder.build()).build();
    }
}

